% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_create_dataset.R
\name{ds_create_dataset}
\alias{ds_create_dataset}
\title{Datastore - create a new resource on an existing dataset}
\usage{
ds_create_dataset(
  package_id,
  name,
  path,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{package_id}{(character) Existing package ID (required)}

\item{name}{(character) Name of the new resource (required)}

\item{path}{(character) Path of the file to add (required)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Datastore - create a new resource on an existing dataset
}
\details{
This function is deprecated - will be defunct in the next version
of this package
}
\examples{
\dontrun{
path <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
ckanr_setup(url = "https://demo.ckan.org/", key = "my-demo-ckan-org-api-key")
ds_create_dataset(package_id='testingagain', name="mydata", path = path)

# Testing: see ?ckanr_setup to set test settings
ckanr_setup(test_url = "http://my-ckan.org/",
            test_key = "my-ckan-api-key",
            test_did="an-existing-package-id",
            test_rid="an-existing-resource-id")
ds_create_dataset(package_id=get_test_pid(), name="mydata",
                  path=system.file("examples",
                                   "actinidiaceae.csv",
                                   package = "ckanr"),
                  key = get_test_key(),
                  url = get_test_url())
}
}
\references{
http://docs.ckan.org/en/latest/api/index.html#ckan.logic.action.create.resource_create
}
