% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closestdist_gcms.R
\name{closestdist_gcms}
\alias{closestdist_gcms}
\title{Distance between General Circulation Models (GCMs)}
\usage{
closestdist_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  k = NULL,
  method = "euclidean",
  minimize_difference = TRUE,
  max_difference = NULL
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector with names of the bioclimatic variables to compare, or 'all'
to include all available variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted.
Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Whether to apply centering and scaling to the data. Default is \code{TRUE}.}

\item{k}{Numeric. The number of GCMs to include in the subset. If \code{NULL} (default), stopping criteria are applied.}

\item{method}{The distance method to use. Default is "euclidean". Possible values are: "euclidean",
"maximum", "manhattan", "canberra", "binary", "minkowski", "pearson", "spearman", or "kendall". See \code{?dist_gcms}.}

\item{minimize_difference}{Logical. If \code{k = NULL}, the function will search for the optimal
value of \code{k} by adding GCMs to the subset until the mean distance starts to diverge from the
global mean distance. Default is \code{TRUE}.}

\item{max_difference}{Numeric. A distance threshold to stop searching for the optimal subset.
If \code{NULL}, no threshold is set. Default is \code{NULL}.}
}
\value{
A set of GCMs that have a mean distance closer to the global mean distance of all GCMs provided in \code{s}.
}
\description{
This function compares future climate projections from multiple General Circulation Models (GCMs)
based on their similarity in terms of bioclimatic variables. It computes distance metrics between
GCMs and identifies subsets of GCMs that are similar to the global set.
}
\details{
The \code{minimize_difference} option searches for the best value of \code{k} by progressively
adding GCMs to the subset. The function monitors the mean distance between the subset of GCMs and
the global mean distance, stopping when the distance begins to increase.
The \code{max_difference} option sets a maximum distance difference. If the mean distance between
the subset GCMs exceeds this threshold, the function stops searching and returns the current subset.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)
study_area <- terra::ext(c(-80, -30, -50, 10)) |> terra::vect(crs="epsg:4326")
closestdist_gcms(s, var_names, study_area, method = "euclidean")

}
\seealso{
\code{\link{cor_gcms}} \code{\link{dist_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
