% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseLocator.R
\name{caseLocator}
\alias{caseLocator}
\title{Locate case by numerical ID.}
\usage{
caseLocator(case, zoom = FALSE, observed = TRUE, radius = 2,
  stacked = TRUE)
}
\arguments{
\item{case}{Numeric or Integer. Whole number between 1 and 578.}

\item{zoom}{Logical.}

\item{observed}{Logical. \code{TRUE} for observed. \code{FALSE} for simulated.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{stacked}{Logical. \code{TRUE} uses \code{fatalities} ("stacked" data); \code{FALSE} uses \code{fatalities.address} ("unstacked" data).}
}
\value{
A base R graphics plot.
}
\description{
Highlight selected observed or simulated case and its home road segment.
}
\examples{
caseLocator(290)
caseLocator(290, zoom = TRUE)
caseLocator(290, stacked = FALSE)
caseLocator(290, zoom = TRUE, stacked = FALSE)
caseLocator(290, observed = FALSE)
}
\seealso{
\code{\link{fatalities}}, \code{\link{fatalities.address}}, \code{\link{fatalities.unstacked}}
}
