% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walkingPath.R
\name{plot.walking_path}
\alias{plot.walking_path}
\title{Plot the walking path between selected cases and/or pumps.}
\usage{
\method{plot}{walking_path}(x, zoom = TRUE, radius = 0.5,
  unit.posts = "distance", unit.interval = NULL, alpha.level = 1, ...)
}
\arguments{
\item{x}{An object of class "walking_path" created by walkingPath().}

\item{zoom}{Logical.}

\item{radius}{Numeric. Control the degree of zoom.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts; NULL for no posts.}

\item{unit.interval}{Numeric. Set interval between posts. When "unit.posts" is "distance", "unit.interval" automatically defaults to 50 meters. When "unit.posts" is "time", "unit.interval" automatically defaults to 60 seconds.}

\item{alpha.level}{Numeric. Alpha level transparency for path: a value in [0, 1].}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot the walking path between selected cases and/or pumps.
}
\section{Note}{
 Arrow represent mileposts or timeposts to the destination.
}

\examples{
plot(walkingPath(15))
plot(walkingPath(15), unit.posts = "time")
}
