% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMilePosts.R
\name{addMilePosts}
\alias{addMilePosts}
\title{Add distance or time based "mileposts" to a walking neighborhood plot.}
\usage{
addMilePosts(pump.subset = NULL, pump.select = NULL, vestry = FALSE,
  unit = "distance", interval = NULL, walking.speed = 5,
  type = "arrows", multi.core = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to select (subset) from the neighborhoods defined by "pump.select". Negative selection possible. NULL selects all pumps in "pump.select".}

\item{pump.select}{Numeric. Numeric vector of pumps to define possible pump neighborhoods (i.e. the "population"). Negative selection is possible. NULL selects all "observed" pumps (i.e., pumps with at least one case).}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 from the original map.}

\item{unit}{Character. Milepost unit of measurement: "distance" or "time".}

\item{interval}{Numeric. Interval between mileposts: 50 meters for "distance";  60 seconds for "time".}

\item{walking.speed}{Numeric. Default walking speed is 5 km/hr.}

\item{type}{Character. "arrows" or "points".}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}
}
\value{
R base graphics arrows or points.
}
\description{
Add distance or time based "mileposts" to a walking neighborhood plot.
}
