% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_temperature_curve.R
\name{Empirical_hourly_temperatures}
\alias{Empirical_hourly_temperatures}
\title{Empirical daily temperature prediction}
\usage{
Empirical_hourly_temperatures(Tdaily, empi_coeffs)
}
\arguments{
\item{Tdaily}{data.frame containing daily minimum and maximum temperatures.
Must contain columns \code{Year} (year of observation), \code{Month} (month of observation),
\code{Day} (day of observation), \code{Tmin} (Minimum daily temperature) and \code{Tmax}
(Maximum daily temperature).}

\item{empi_coeffs}{data.frame containing coefficients for the hourly temperature
prediction, e.g. generated with the function
\code{\link[=Empirical_daily_temperature_curve]{Empirical_daily_temperature_curve}}.
Needs to contain the following columns: \code{Month} (month for which coefficient
applies), \code{Hour} (hour for which coefficient applies) and \code{Prediction_coefficient}
(the coefficient used for empirical temperature prediction). Coefficients
indicate, by what fraction of the daily temperature range the temperature during
the specified hour is above the daily minimum temperature.}
}
\value{
data.frame containing all columns of the \code{Tdaily} dataset, but also the
columns \code{Hour} and \code{Temp}, for the hour of the day and the predicted temperature,
respectively.
}
\description{
This function generates hourly temperatures from daily minimum and maximum
temperatures, based on an empirical relationship of these two daily 
temperature extremes with the hourly temperature. Usually, this relationship
will have been determined with the \cr
\code{\link[=Empirical_daily_temperature_curve]{Empirical_daily_temperature_curve}}
function.
}
\examples{
 
coeffs<-Empirical_daily_temperature_curve(Winters_hours_gaps)
Winters_daily<-make_all_day_table(Winters_hours_gaps, input_timestep="hour")
Empirical_hourly_temperatures(Winters_daily,coeffs)

}
\author{
Eike Luedeling
}
\keyword{utility}
