% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chile_agromet2chillR.R
\name{chile_agromet2chillR}
\alias{chile_agromet2chillR}
\title{Convert a weather file downloaded from the Chilean Agromet website to chillR
format}
\usage{
chile_agromet2chillR(downloaded_weather_file, drop_most = TRUE)
}
\arguments{
\item{downloaded_weather_file}{full path of a weather file downloaded from
the Chilean Agromet website (http://agromet.inia.cl/) as an alleged Excel
file (it has some formatting issues).}

\item{drop_most}{boolean variable indicating if most columns should be
dropped from the file. If set to TRUE (default), only essential columns for
running chillR functions are retained.}
}
\value{
a data.frame with weather data, according to the downloaded file
provided as input. If drop_most is FALSE, all columns from the original
dataset are preserved, although some column names are adjusted to chillR's
preferences ("Year","Month","Day","Tmin","Tmax","Tmean","Prec", if these
columns are present). If drop_most is TRUE, only columns likely to be of
interest to chillR users are retained.
}
\description{
Convert downloaded weather data into a data frame that makes running other
chillR functions easy.
}
\details{
Processing the data with this function will make the data work well with the
remainder of this package.
}
\note{
Many databases have data quality flags, which may sometimes indicate
that data aren't reliable. These are not considered by this function!
}
\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2005),])  # this line is
#only here to make the example run, even without downloading a file

# FOLLOW THE INSTRUCTIONS IN THE LINE BELOW THIS; AND THEN  RUN THE LINE AFTER THAT (without the #)
# download an Excel file from the website and save it to disk (path: {X}) 
#weather<-fix_weather(chile_agromet2chillR({x}))

hourtemps<-stack_hourly_temps(weather, latitude=50.4)
chilling(hourtemps,305,60)

}
\references{
The chillR package:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat
requirements of cherry trees - a statistical approach. International Journal
of Biometeorology 57,679-689.
}
\author{
Eike Luedeling
}
\keyword{utilities}
