% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{make_percentile_tab}
\alias{make_percentile_tab}
\title{calculate raw values}
\usage{
make_percentile_tab(ref, item, perc = c(2.5, 5, 50, 95, 97.5),
  stack = F, age = NULL, include.pars = T, digits = 4, sex)
}
\arguments{
\item{ref}{Refgroup object}

\item{item}{name of the measurement item}

\item{perc}{vector of percentiles to be calculated}

\item{stack}{wether or not the data should be stacked, stacked data
would most possibly be used in ggplot2}

\item{age}{desired values of age}

\item{include.pars}{indicator whether or not parameters should be included}

\item{digits}{specification of number of decimal places}

\item{sex}{name of the sex variable (character) if different from sex, not
functional in this version and therefore ignored}
}
\value{
data frame either with the different percentiles as columns
or, if stacked, as data frame with four columns: age, sex, variable, value
}
\description{
Calculate raw values for percentile curve
}
\details{
calculates quantile values for given RefGroup and given
percentiles
}
\examples{
ptab <- make_percentile_tab(ref = kro.ref,
                            item = "height",
                           perc = c(2.5,10,50,90,97.5),
                           stack = TRUE)

ggplot2::ggplot(ptab, ggplot2::aes(x = age, y = value, colour = variable)) +
   ggplot2::geom_line() +
   ggplot2::facet_wrap(~ sex, nrow = 2)
}
\author{
Mandy Vogel
}
