% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmpt04.R
\docType{data}
\name{rmpt04_main}
\alias{rmpt04_main}
\alias{rmpt04_pre}
\alias{rmpt04}
\title{\code{RMPT04}Extent of Exposure by Ethnic Origin for Risk Management Plan Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
rmpt04_main(
  adam_db,
  summaryvars = "ETHNIC",
  show_tot = TRUE,
  row_split_var = NULL,
  col_split_var = NULL,
  overall_col_lbl = NULL,
  ...
)

rmpt04_pre(adam_db, summaryvars = "ETHNIC", ...)

rmpt04
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{summaryvars}{(\code{string}) variables to be analyzed. The label attribute of the corresponding columns in \code{adex}
table of \code{adam_db} is used as label.}

\item{show_tot}{(\code{flag}) whether to display the cumulative total.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{col_split_var}{(\code{string}) additional column splitting variable.}

\item{overall_col_lbl}{(\code{string}) name of the overall column. If \code{NULL}, no overall level is added.}

\item{...}{not used.}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
The \code{RMPT04} table provides an overview of duration of exposure extent.
}
\details{
\itemize{
\item Person time is the sum of exposure across all patients.
\item Summary statistics are by default based on the number of patients in the corresponding \code{N} row
(number of non-missing values).
\item Does not remove zero-count rows unless overridden with \code{prune_0 = TRUE}.
}
}
\section{Functions}{
\itemize{
\item \code{rmpt04_main()}: Main TLG function

\item \code{rmpt04_pre()}: Preprocessing

}}
\examples{
run(rmpt04, syn_data)
}
\keyword{datasets}
