% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{online.network}
\alias{online.network}
\title{Online change point detection for network data.}
\usage{
online.network(
  data_mat1,
  data_mat2,
  self = TRUE,
  b_vec = NULL,
  train_mat = NULL,
  alpha = NULL,
  gamma = NULL,
  permu_num = NULL
)
}
\arguments{
\item{data_mat1}{A \code{numeric} matrix of observations with with horizontal axis being time, and with each column be the vectorized adjacency matrix.}

\item{data_mat2}{A \code{numeric} matrix of observations with with horizontal axis being time, and with each column be the vectorized adjacency matrix (data_mat1 and data_mat2 are independent and have the same dimensions ).}

\item{self}{A \code{logic} scalar indicating if adjacency matrices are required to have self-loop.}

\item{b_vec}{A \code{numeric} vector of thresholds b_t with t >= 2.}

\item{train_mat}{A \code{numeric} matrix of training data from a pre-change distribution(no change point), which is only needed to when b_vec is NULL in order to calibrate b_t.}

\item{alpha}{A \code{numeric} scalar in (0,1) representing the level.}

\item{gamma}{An \code{integer} scalar of desired average run length.}

\item{permu_num}{An \code{integer} scalar of number of random permutation for calibration.}
}
\value{
A \code{list} with the following structure:
 \item{cpt}{Estimated change point}
 \item{score}{A \code{numeric} vector of computed cumsum statistics}
 \item{b_vec}{A \code{numeric} vector of thresholds b_t with t >= 2}
}
\description{
Perform online change point detection for network data by controlling the false alarm rate at level alpha or controlling the average run length gamma. The default choice of the tuning parameters tau1, tau2 and tau3 are used (see Section 4.1 of the reference).
}
\examples{
set.seed(123)
p = 15 # number of nodes
rho = 0.5 # sparsity parameter
block_num = 3 # number of groups for SBM
n = 100 # sample size for each segment
# connectivity matrix for the first and the third segments
conn1_mat = rho * matrix(c(0.6,1,0.6,1,0.6,0.5,0.6,0.5,0.6), nrow = 3) 
# connectivity matrix for the second segment
conn2_mat = rho * matrix(c(0.6,0.5,0.6,0.5,0.6,1,0.6,1,0.6), nrow = 3) 
set.seed(1)
can_vec = sample(1:p, replace = FALSE) # randomly assign nodes into groups
sbm1 = simu.SBM(conn1_mat, can_vec, n, symm = TRUE, self = TRUE)
sbm2 = simu.SBM(conn2_mat, can_vec, n, symm = TRUE, self = TRUE)
data_mat = cbind(sbm1$obs_mat, sbm2$obs_mat)
data_mat1 = data_mat[,seq(1,ncol(data_mat),2)]
data_mat2 = data_mat[,seq(2,ncol(data_mat),2)]
train_mat = simu.SBM(conn1_mat, can_vec, n = 150, symm = TRUE, self = TRUE)$obs_mat
temp = online.network(data_mat1, data_mat2, self = TRUE, b_vec = NULL, train_mat, alpha = 0.05, 
                      gamma = NULL, permu_num = 20)
cpt_hat = 2 * temp$cpt
}
\references{
Yu, Padilla, Wang and Rinaldo (2021) <arxiv:2101.05477>
}
\author{
Oscar Hernan Madrid Padilla & Haotian Xu
}
