% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_stats.R
\name{cfbd_stats_game_advanced}
\alias{cfbd_stats_game_advanced}
\title{\strong{Get game advanced stats}}
\usage{
cfbd_stats_game_advanced(
  year,
  week = NULL,
  team = NULL,
  opponent = NULL,
  excl_garbage_time = FALSE,
  season_type = "both"
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{team}{(\emph{String} optional): D-I Team}

\item{opponent}{(\emph{String} optional): Opponent D-I Team}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE/FALSE)}

\item{season_type}{(\emph{String} default both): Select Season Type: regular, postseason, or both.}
}
\value{
\code{\link[=cfbd_stats_game_advanced]{cfbd_stats_game_advanced()}} - A data frame with 60 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{team}: character.}{Team name.}
\item{\code{opponent}: character.}{Opponent team name.}
\item{\code{off_plays}: integer.}{Offense plays in the game.}
\item{\code{off_drives}: integer.}{Offense drives in the game.}
\item{\code{off_ppa}: double.}{Offense predicted points added (PPA).}
\item{\code{off_total_ppa}: double.}{Offense total predicted points added (PPA).}
\item{\code{off_success_rate}: double.}{Offense success rate.}
\item{\code{off_explosiveness}: double.}{Offense explosiveness rate.}
\item{\code{off_power_success}: double.}{Offense power success rate.}
\item{\code{off_stuff_rate}: double.}{Opponent stuff rate.}
\item{\code{off_line_yds}: double.}{Offensive line yards.}
\item{\code{off_line_yds_total}: integer.}{Offensive line yards total.}
\item{\code{off_second_lvl_yds}: double.}{Offense second-level yards.}
\item{\code{off_second_lvl_yds_total}: integer.}{Offense second-level yards total.}
\item{\code{off_open_field_yds}: integer.}{Offense open field yards.}
\item{\code{off_open_field_yds_total}: integer.}{Offense open field yards total.}
\item{\code{off_standard_downs_ppa}: double.}{Offense standard downs predicted points added (PPA).}
\item{\code{off_standard_downs_success_rate}: double.}{Offense standard downs success rate.}
\item{\code{off_standard_downs_explosiveness}: double.}{Offense standard downs explosiveness rate.}
\item{\code{off_passing_downs_ppa}: double.}{Offense passing downs predicted points added (PPA).}
\item{\code{off_passing_downs_success_rate}: double.}{Offense passing downs success rate.}
\item{\code{off_passing_downs_explosiveness}: double.}{Offense passing downs explosiveness rate.}
\item{\code{off_rushing_plays_ppa}: double.}{Offense rushing plays predicted points added (PPA).}
\item{\code{off_rushing_plays_total_ppa}: double.}{Offense rushing plays total predicted points added (PPA).}
\item{\code{off_rushing_plays_success_rate}: double.}{Offense rushing plays success rate.}
\item{\code{off_rushing_plays_explosiveness}: double.}{Offense rushing plays explosiveness rate.}
\item{\code{off_passing_plays_ppa}: double.}{Offense passing plays predicted points added (PPA).}
\item{\code{off_passing_plays_total_ppa}: double.}{Offense passing plays total predicted points added (PPA).}
\item{\code{off_passing_plays_success_rate}: double.}{Offense passing plays success rate.}
\item{\code{off_passing_plays_explosiveness}: double.}{Offense passing plays explosiveness rate.}
\item{\code{def_plays}: integer.}{Defense plays in the game.}
\item{\code{def_drives}: integer.}{Defense drives in the game.}
\item{\code{def_ppa}: double.}{Defense predicted points added (PPA).}
\item{\code{def_total_ppa}: double.}{Defense total predicted points added (PPA).}
\item{\code{def_success_rate}: double.}{Defense success rate.}
\item{\code{def_explosiveness}: double.}{Defense explosiveness rate.}
\item{\code{def_power_success}: double.}{Defense power success rate.}
\item{\code{def_stuff_rate}: double.}{Opponent stuff rate.}
\item{\code{def_line_yds}: double.}{Offensive line yards.}
\item{\code{def_line_yds_total}: integer.}{Offensive line yards total.}
\item{\code{def_second_lvl_yds}: double.}{Defense second-level yards.}
\item{\code{def_second_lvl_yds_total}: integer.}{Defense second-level yards total.}
\item{\code{def_open_field_yds}: integer.}{Defense open field yards.}
\item{\code{def_open_field_yds_total}: integer.}{Defense open field yards total.}
\item{\code{def_standard_downs_ppa}: double.}{Defense standard downs predicted points added (PPA).}
\item{\code{def_standard_downs_success_rate}: double.}{Defense standard downs success rate.}
\item{\code{def_standard_downs_explosiveness}: double.}{Defense standard downs explosiveness rate.}
\item{\code{def_passing_downs_ppa}: double.}{Defense passing downs predicted points added (PPA).}
\item{\code{def_passing_downs_success_rate}: double.}{Defense passing downs success rate.}
\item{\code{def_passing_downs_explosiveness}: double.}{Defense passing downs explosiveness rate.}
\item{\code{def_rushing_plays_ppa}: double.}{Defense rushing plays predicted points added (PPA).}
\item{\code{def_rushing_plays_total_ppa}: double.}{Defense rushing plays total predicted points added (PPA).}
\item{\code{def_rushing_plays_success_rate}: double.}{Defense rushing plays success rate.}
\item{\code{def_rushing_plays_explosiveness}: double.}{Defense rushing plays explosiveness rate.}
\item{\code{def_passing_plays_ppa}: double.}{Defense passing plays predicted points added (PPA).}
\item{\code{def_passing_plays_total_ppa}: double.}{Defense passing plays total predicted points added (PPA).}
\item{\code{def_passing_plays_success_rate}: double.}{Defense passing plays success rate.}
\item{\code{def_passing_plays_explosiveness}: double.}{Defense passing plays explosiveness rate.}
}
}
\description{
\strong{Get game advanced stats}
}
\examples{
\donttest{
   try(cfbd_stats_game_advanced(year = 2018, week = 12, team = "Texas A&M"))

   try(cfbd_stats_game_advanced(2019, team = "LSU"))

   try(cfbd_stats_game_advanced(2013, team = "Florida State"))
}

}
\keyword{Advanced}
\keyword{Game}
\keyword{Stats}
