% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cde-class_and_methods.r
\name{plot.cde_df}
\alias{plot.cde_df}
\title{Plot method for \code{cde_df} output}
\usage{
\method{plot}{cde_df}(x, ...)
}
\arguments{
\item{x}{An object of class \code{cde_df} to be plotted.}

\item{...}{Other arguments passed on to individual methods. The only other
argument implemented at present is \code{scheme}. For \code{status} and 
\code{objectives} data this defines which colour scheme to use with plots. It 
defaults to a viridis-based scheme (\code{scheme="vir"}). Alternatively, the 
colours specified in the WFD document can be used by specifying 
\code{scheme="wfd"}.}
}
\description{
Default plots of the output main \code{get_} functions.
Details of the plots for different data are given below.
 
 For \code{status} and \code{objectives} produces a (stacked) 
 percentage barplot of waterbody observed or predicted (objective) 
 status information for a given set of data. 

For \code{rnag}, \code{measures} or \code{pa} produces a frequency 
histogram. The columns plotted for each data type are given below:

\itemize{
  \item{rnag} 
  (pressure_tier_3)
  \item {measures} 
  (measure_tier_1)
  \item {pa} 
  (protected_area_type)
}
The full detail of the different data being plotted can be found in 
the EA Catchment Data Explorer API reference:
\url{https://environment.data.gov.uk/catchment-planning/ui/reference}
     
Plotting is only possible for MC, OC or RBD downloads.
}
