% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{miscmethods.cbc_errors}
\alias{miscmethods.cbc_errors}
\alias{plot.cbc_errors}
\title{Methods for cbc_errors objects}
\usage{
\method{plot}{cbc_errors}(x, ...)
}
\arguments{
\item{x}{is an object of class \code{cbc_errors}.}

\item{...}{further arguments.}
}
\value{
Returns a ggplot2 object plotting standard errors versus sample
size.
}
\description{
Miscellaneous methods for \code{cbc_errors} class objects.
}
\examples{
library(cbcTools)

# A simple conjoint experiment about apples

# Generate all possible profiles
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  type      = c("Fuji", "Gala", "Honeycrisp"),
  freshness = c('Poor', 'Average', 'Excellent')
)

# Make a randomized survey design
design <- cbc_design(
  profiles = profiles,
  n_resp   = 300, # Number of respondents
  n_alts   = 3, # Number of alternatives per question
  n_q      = 6 # Number of questions per respondent
)

# Simulate random choices
data <- cbc_choices(
  design = design,
  obsID  = "obsID"
)

# Conduct a power analysis
power <- cbc_power(
  data    = data,
  pars    = c("price", "type", "freshness"),
  outcome = "choice",
  obsID   = "obsID",
  nbreaks = 10,
  n_q     = 6
)

# Visualize the results
plot(power)
}
