% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_weight.R
\name{calc_weight}
\alias{calc_weight}
\title{Estimate causal weights}
\usage{
calc_weight(
  data,
  constraint = NULL,
  estimand = c("ATE", "ATT", "ATC", "cATE", "feasible"),
  method = supported.methods(),
  formula = NULL,
  transport.matrix = FALSE,
  grid.search = FALSE,
  ...
)
}
\arguments{
\item{data}{Either a matrix, a data.frame, or a DataSim class. Arguments "balance.covariates" and "treatment.indicator" must be provided in the \code{...} arguments if data is of class data.frame or matrix.}

\item{constraint}{The constraints or penalties for the weights. See details.}

\item{estimand}{The estimand of interest. One of "ATT","ATC", or "ATE".}

\item{method}{The method to estimate the causal weights. Must be one of the methods returned by \code{\link[=supported.methods]{supported.methods()}}.}

\item{formula}{The formula for creating the design matrix used in various methods. See details.}

\item{transport.matrix}{Should the method calculate the transportation matrix if not done as a part of the method (TRUE/FALSE)? Default is FALSE.}

\item{grid.search}{Should hyperparameters be selected by a grid search? Only available for "SBW" and "COT"/"Wasserstein" methods.}

\item{...}{Many additional arguments are possible depending on the chosen method. See details for more information. Arguments "balance.covariates" and "treatment.indicator" must be provided if data is of class data.frame or matrix.}
}
\value{
An object of class \link[=causalWeights-class]{causalWeights}
}
\description{
Estimate causal weights
}
\details{
We detail some of the particulars of the function arguments below.
\subsection{\code{data}}{

The following classes are recognized by the \code{data} variable.
\subsection{DataSim class}{

The DataSim class is provided by this package for simulations. You can pass a DataSim object (once data has been simulated) to this function
and it will be recognized and handled appropriately.
}

\subsection{data.frame or matrix}{

If the \code{data} argument is of class \code{data.frame} or \code{matrix}, then additional arguments are necessary to pass in the dots (\code{...}).
These \emph{must} include a vector argument \code{balance.covariates} and an integer or character in the \code{treatment.indicator} argument. The
\code{balance.covariates} argument should be either an integer vector giving the column numbers of the covariates to balance or a character vector
giving the names of the columns to balance. Similarly, the \code{treatment.indicator} argument should be a integer giving the column number of the
treatment labels or a character giving the column name.
}

}

\subsection{Constraints}{

The constraint argument is used by the balancing methods like "SBW". This will specify a tolerance for basis function balance.

If method "COT"/"Wasserstein" is used, will specify the penalty parameter to put on the weights. For "ATT" and "ATC" estimands, must be of the form \verb{list(penalty = ###)}, while for estimand "ATE", must be a list of length 2 specifying penalty first for the controls and then for treated: \verb{list(list(penalty = ###), list(penalty = ###))}.

This argument is not needed if \code{grid.search} is TRUE.
}

\subsection{Formula}{

For methods "SBW" or "COT", should be a formula object or character without a response but with the covariate functions desired. e.g., "~." includes all covariates without transformation.

For methods "Logistic" and "Probit", a propensity score model either as a formula object or character: "z ~.".
}

\subsection{Additional arguments in \code{...}}{

In addition to the already mentioned arguments, there are several additional
optional arguments for the method "COT".
\itemize{
\item \code{p}. The power of the Wasserstein distance to use.
\item \code{metric}. The metric to use for the ground cost function. See \code{\link[=dist.metrics]{dist.metrics()}} for supported distance metrics.
\item \code{penalty}. What type of penalty should be used on the weights? Must be one of "entropy" or "L2".
\item \code{add.divergence}. TRUE or FALSE. If TRUE, \code{penalty} defaults to entropy.
and will calculate the Sinkhorn divergence version of Causal Optimal Transport.
If choosing Sinkhorn divergences, the Python
package \code{geomloss} must be installed.
\item \code{balance.constraints}. The tolerance for the balancing basis function methods.
\item \code{cost}. If the cost matrix is already calculated, you can supply this to potentially save time.
}

Additionally, methods like "SBW" and "COT" need the specification of a solver function if using balancing functions, i.e. if the \code{formula} argument is specified.
\itemize{
\item \code{solver}. Should be one of "mosek" or "osqp".
}
}
}
\examples{
set.seed(23483)
n <- 2^7
p <- 6
overlap <- "low"
design <- "A"
estimate <- "ATE"
#### get simulation functions ####
data <- causalOT::Hainmueller$new(n = n, p = p, 
      design = design, overlap = overlap)
      data$gen_data()
weights <- calc_weight(data = data, 
      p = p,
      estimand = estimate,
      method = "NNM")
\dontrun{
# Needs Python package GeomLoss
COTweights <- calc_weight(data = data, 
      p = 2,
      constraint = list(list(penalty = 1000),
                        list(penalty = 10000)),
      estimand = estimate,
      method = "COT",
      penalty = "entropy",
      add.divergence = TRUE,
      verbose = TRUE
      )
# with basis function balancing.
 COTweightsBF <- calc_weight(data = data, 
      p = 2,
      constraint = list(list(penalty = 1000),
                        list(penalty = 10000)),
      estimand = estimate,
      method = "COT",
      penalty = "entropy",
      add.divergence = TRUE,
      formula = "~.",
      balance.constraints = 0.2,
      solver = "osqp",
      verbose = TRUE
      )
}
}
\seealso{
\link[=estimate_effect]{estimate_effect()}
}
