% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{list_columns}
\alias{list_columns}
\title{List Columns}
\usage{
list_columns(sc, table, database = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{table}{\code{character(1)}. The name of the table.}

\item{database}{\code{character(1)}. The name of the database for which the
functions should be listed (default: \code{NULL}).}
}
\value{
A \code{tibble} with 6 columns:
\itemize{
\item \code{name} - The name of the column.
\item \code{description} - Description of the column.
\item \code{dataType} - The column data type.
\item \code{nullable} - Whether the column is nullable or not.
\item \code{isPartition} - Whether the column is partitioned or not.
\item \code{isBucket} - Whether the column is broken in buckets.
}
}
\description{
Returns a list of columns for the given table/view in the specified database.
The result includes the name, description, dataType, whether it is nullable
or if it is partitioned and if it is broken in buckets.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
mtcars_spark <- sparklyr::copy_to(dest = sc, df = mtcars)
list_columns(sc = sc, table = "mtcars")
}

}
