% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_striated}
\alias{sc_striated}
\alias{sc_striated.default}
\alias{sc_striated.scree}
\alias{sc_striated.igraph}
\title{Compute striated scagnostic measure using MST}
\usage{
sc_striated(x, y)

\method{sc_striated}{default}(x, y)

\method{sc_striated}{scree}(x, y = NULL)

\method{sc_striated}{igraph}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's striated score.
}
\description{
Compute striated scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(dplyr)
  data(anscombe_tidy)
  ggplot(anscombe_tidy, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~set, ncol=2, scales = "free")
  sc_striated(anscombe$x1, anscombe$y1)
  sc_striated(anscombe$x2, anscombe$y2)

}
