% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitDist.R
\docType{methods}
\name{PPPlot}
\alias{PPPlot}
\alias{PPPlot,FitDist-method}
\alias{PPPlot,ANY-method}
\title{P-P Plot of data and fitted distribution}
\usage{
PPPlot(object, ...)

\S4method{PPPlot}{FitDist}(object, n = missing)
}
\arguments{
\item{object}{FitDist Object}

\item{...}{Additional function arguments}

\item{n}{Number of samples, should not be used in current setting}
}
\description{
P-P Plot of data and fitted distribution
}
\examples{
library(cascsim)
data(claimdata)

#frequecy fitting example
findex <- new("Index", startDate = as.Date("2012-01-01"), tabulate=TRUE, monthlyIndex = c(rep(1,11),
cumprod(c(1,rep(1.5^(1/12),11))),cumprod(c(1.5,rep((1.3/1.5)^(1/12),11))),
cumprod(c(1.3,rep((1.35/1.3)^(1/12),11))),cumprod(c(1.35,rep((1.4/1.35)^(1/12),11))),1.4))
rawdata <- as.data.frame(as.Date(claimdata[(claimdata[,"LoB"]=="Auto" & 
claimdata[,"Type"]=="H"),]$occurrenceDate))
colnames(rawdata)<-"occurrenceDate"
xFit <- new("FitDist", observation=rawdata, trend=findex,startDate = as.Date("2012-01-01"),
method="mle",ifreq=TRUE,idate=TRUE, freq="Monthly")
xFit <- setFitdata(xFit)
setTrialDist(xFit) <- new("Poisson")
xFit@soutput
observationPlot(xFit)
PPPlot(xFit)
}
