% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.R
\name{background}
\alias{background}
\title{Backgrounds}
\usage{
background(x, color)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{One of \code{"blue"}, \code{"indigo"}, \code{"purple"}, \code{"red"}, \code{"orange"}, \code{"yellow"}, \code{"green"}, \code{"teal"}, \code{"cyan"}, \code{"white"}, or \code{"transparent"} specifying the
background color of the tag element.}
}
\description{
The \code{background()} function adjusts the background color of a tag element.
}
\section{Buttons}{
Use \code{background()} to modify shiny’s action buttons.\if{html}{\out{<div class="r">}}\preformatted{actionButton("id", "Take action") \%>\%
  background("green")
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<button id="id" type="button" class="btn btn-default action-button cas-bg-green">
}}


Take action\if{html}{\out{
</button>
}}
\if{html}{\out{
<!--/html_preserve-->
}}


With a couple other functions we can take our improvement a step
further.\if{html}{\out{<div class="r">}}\preformatted{actionButton("id", "Take action") \%>\%
  background("green") \%>\%
  border("green") \%>\%
  shadow("small")
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<button id="id" type="button" class="btn btn-default action-button cas-bg-green cas-border cas-border-green cas-border-round-md cas-shadow-sm">
}}


Take action\if{html}{\out{
</button>
}}
\if{html}{\out{
<!--/html_preserve-->
}}


Shiny’s download buttons include \code{...}, so we can use the \code{.style}
pronoun!\if{html}{\out{<div class="r">}}\preformatted{downloadButton(
  .style \%>\%
    background("white") \%>\%
    border("blue"),
  outputId = "dwnld",
  label = "Do a download",
  class = NULL
)
}\if{html}{\out{</div>}}
}

\section{Panels}{
\if{html}{\out{<div class="r">}}\preformatted{sidebarLayout(
  sidebarPanel(
    .style \%>\%
      background("blue"),
    "It's alive"
  ),
  mainPanel(
    .style \%>\%
      background("red"),
    "It's panel"
  )
)
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<div class="row">
}}
\if{html}{\out{
<div class="col-sm-4">
}}
\if{html}{\out{
<form class="well cas-bg-blue">
}}


It’s alive\if{html}{\out{
</form>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="col-sm-8 cas-bg-red">
}}


It’s panel\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<!--/html_preserve-->
}}
}

\section{Colors}{
\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<div class="cas-d-flex cas-flex-justify-between cas-flex-wrap">
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


blue\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-blue">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


indigo\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-indigo">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


purple\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-purple">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


red\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-red">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


orange\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-orange">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


yellow\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-yellow">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


green\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-green">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


teal\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-teal">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


cyan\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-cyan">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


white\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-white">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-m-3">
}}
\if{html}{\out{
<div class="cas-text-center">
}}


transparent\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="cas-p-5 cas-bg-transparent">
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<!--/html_preserve-->
}}
}

\examples{

library(htmltools)

div(
  .style \%>\%
    background("white") \%>\%
    border("blue") \%>\%
    text("white"),
  "Nunc porta vulputate tellus.",
  "Suspendisse potenti."
)

}
