% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFigDim.R
\name{getFigDim}
\alias{getFigDim}
\title{Get Figure Dimensions}
\usage{
getFigDim(x, spdf, width = NULL, height = NULL, mar = par("mar"),
  res = 72)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a Spatial*DataFrame.}

\item{spdf}{deprecated, a Spatial*DataFrame.}

\item{width}{width of the figure (in pixels), either width or height 
must be set.}

\item{height}{heigth of the figure (in pixels), either width or height 
must be set.}

\item{mar}{a numerical vector of the form c(bottom, left, top, right) 
which gives the number of lines of margin to be specified on the four 
sides of the plot (see \link{par}).}

\item{res}{the nominal resolution in ppi which will be recorded in the 
bitmap file.}
}
\value{
A vector of width and height in pixels is returned.
}
\description{
Give the dimension of a map figure to be exported in 
raster or vector format. \cr
Output dimension are based on a spatial object dimension ratio, margins of 
the figure, a targeted width or height and a resolution.
}
\details{
The function can be used to export vector or raster files (see examples).
}
\examples{
\dontrun{
data("nuts2006")
italy <- nuts0.spdf[nuts0.spdf$id=="IT",]

## PNG export
# get figure dimension
sizes <- getFigDim(x = italy, width = 450, mar = c(0,0,1.2,0))
# export the map
png(filename = "Italy.png", width = sizes[1], height = sizes[2])
par(mar = c(0,0,1.2,0))
plot(italy, col = NA, border=NA, bg = "#A6CAE0")
plot(world.spdf, col = "#E3DEBF", border = NA, add = TRUE)
plot(italy, col = "#D1914D", border = "white", add = TRUE)
layoutLayer(title = "Map of Italy")
dev.off()

## PDF export
# get figure dimension
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
sizes <- getFigDim(x = mtq, width = 450, mar = c(1,1,2.2,1))
# export the map
pdf(file = "Martinique.pdf", width = sizes[1]/72, height = sizes[2]/72)
par(mar = c(1,1,2.2,1))
plot(st_geometry(mtq), col = "#D1914D", border = "white", bg = "#A6CAE0")
layoutLayer(title = "Map of Martinique")
dev.off()
}
}
