% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_ttest.R
\name{ard_ttest}
\alias{ard_ttest}
\alias{ard_paired_ttest}
\title{ARD t-test}
\usage{
ard_ttest(data, by, variable, ...)

ard_paired_ttest(data, by, variable, id, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to be compared}

\item{...}{arguments passed to \code{t.test(...)}}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name of the subject or participant ID}
}
\value{
ARD data frame
}
\description{
Analysis results data for paired and non-paired t-tests.
}
\details{
For the \code{ard_ttest()} function, the data is expected to be one row per subject.
The data is passed as \code{t.test(data[[variable]] ~ data[[by]], paired = FALSE, ...)}.

For the \code{ard_paired_ttest()} function, the data is expected to be one row
per subject per by level. Before the t-test is calculated, the data are
reshaped to a wide format to be one row per subject.
The data are then passed as
\verb{t.test(x = data_wide[[<by level 1>]], y = data_wide[[<by level 2>]], paired = TRUE, ...)}.
}
\examples{
cards::ADSL |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  ard_ttest(by = ARM, variable = AGE)

# constructing a paired data set,
# where patients receive both treatments
cards::ADSL[c("ARM", "AGE")] |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  dplyr::mutate(.by = ARM, USUBJID = dplyr::row_number()) |>
  dplyr::arrange(USUBJID, ARM) |>
  ard_paired_ttest(by = ARM, variable = AGE, id = USUBJID)
}
