% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve_sys}
\alias{solve_sys}
\title{Solves a system of non-linear equations}
\usage{
solve_sys(lhs, rhs, vars)
}
\arguments{
\item{lhs}{Equation (or equations as row vector/1xn matrix)}

\item{rhs}{Equation (or equations as row vector/1xn matrix)}

\item{vars}{vector of variable names or symbols}
}
\value{
A list with solutions (with class \code{caracas_solve_sys_sol}
for compact printing), each element containing a named
list of the variables' values.
}
\description{
If called as \code{solve_sys(lhs, vars)}
the roots are found.
If called as \code{solve_sys(lhs, rhs, vars)}
the solutions to \code{lhs = rhs} for \code{vars} are found.
}
\examples{
if (has_sympy()) {
  x <- symbol('x')
  exp1 <- 2*x + 2
  exp2 <- x
  solve_sys(cbind(exp1), cbind(exp2), x)
  
  x <- symbol("x")
  y <- symbol("y")
  lhs <- cbind(3*x*y - y, x)
  rhs <- cbind(-5*x, y+4)
  sol <- solve_sys(lhs, rhs, list(x, y))
  sol
}

}
\concept{solve}
