% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-posterior-total-central.R
\name{PosteriorTotalCentral}
\alias{PosteriorTotalCentral}
\title{Posterior Distribution
of the Total Effect Centrality
Over a Specific Time Interval
or a Range of Time Intervals}
\usage{
PosteriorTotalCentral(phi, delta_t, ncores = NULL)
}
\arguments{
\item{phi}{List of numeric matrices.
Each element of the list is a sample
from the posterior distribution
of the drift matrix (\eqn{\boldsymbol{\Phi}}).
Each matrix should have row and column names
pertaining to the variables in the system.}

\item{delta_t}{Numeric.
Time interval
(\eqn{\Delta t}).}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL},
use a single core.
Consider using multiple cores
when number of replications \code{R}
is a large value.}
}
\value{
Returns an object
of class \code{ctmedmc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("PosteriorTotalCentral").}
\item{output}{A list the length of which is equal to
the length of \code{delta_t}.}
}
Each element in the \code{output} list has the following elements:
\describe{
\item{est}{Mean of the posterior distribution
of the total, direct, and indirect effects.}
\item{thetahatstar}{Posterior distribution of the
total, direct, and indirect effects.}
}
}
\description{
This function generates a posterior
distribution
of the total effect centrality
over a specific time interval \eqn{\Delta t}
or a range of time intervals
using the posterior distribution
of the first-order stochastic differential equation model
drift matrix \eqn{\boldsymbol{\Phi}}.
}
\details{
See \code{\link[=TotalCentral]{TotalCentral()}} for more details.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
vcov_phi_vec <- matrix(
  data = c(
    0.002704274, -0.001475275, 0.000949122,
    -0.001619422, 0.000885122, -0.000569404,
    0.00085493, -0.000465824, 0.000297815,
    -0.001475275, 0.004428442, -0.002642303,
    0.000980573, -0.00271817, 0.001618805,
    -0.000586921, 0.001478421, -0.000871547,
    0.000949122, -0.002642303, 0.006402668,
    -0.000697798, 0.001813471, -0.004043138,
    0.000463086, -0.001120949, 0.002271711,
    -0.001619422, 0.000980573, -0.000697798,
    0.002079286, -0.001152501, 0.000753,
    -0.001528701, 0.000820587, -0.000517524,
    0.000885122, -0.00271817, 0.001813471,
    -0.001152501, 0.00342605, -0.002075005,
    0.000899165, -0.002532849, 0.001475579,
    -0.000569404, 0.001618805, -0.004043138,
    0.000753, -0.002075005, 0.004984032,
    -0.000622255, 0.001634917, -0.003705661,
    0.00085493, -0.000586921, 0.000463086,
    -0.001528701, 0.000899165, -0.000622255,
    0.002060076, -0.001096684, 0.000686386,
    -0.000465824, 0.001478421, -0.001120949,
    0.000820587, -0.002532849, 0.001634917,
    -0.001096684, 0.003328692, -0.001926088,
    0.000297815, -0.000871547, 0.002271711,
    -0.000517524, 0.001475579, -0.003705661,
    0.000686386, -0.001926088, 0.004726235
  ),
  nrow = 9
)

phi <- MCPhi(
  phi = phi,
  vcov_phi_vec = vcov_phi_vec,
  R = 1000L
)$output

# Specific time interval ----------------------------------------------------
PosteriorTotalCentral(
  phi = phi,
  delta_t = 1
)

# Range of time intervals ---------------------------------------------------
posterior <- PosteriorTotalCentral(
  phi = phi,
  delta_t = 1:5
)

# Methods -------------------------------------------------------------------
# PosteriorTotalCentral has a number of methods including
# print, summary, confint, and plot
print(posterior)
summary(posterior)
confint(posterior, level = 0.95)
plot(posterior)

}
\references{
Bollen, K. A. (1987).
Total, direct, and indirect effects in structural equation models.
Sociological Methodology, 17, 37.
\doi{10.2307/271028}

Deboeck, P. R., & Preacher, K. J. (2015).
No need to be discrete:
A method for continuous time mediation analysis.
Structural Equation Modeling: A Multidisciplinary Journal, 23 (1), 61–75.
\doi{10.1080/10705511.2014.973960}

Ryan, O., & Hamaker, E. L. (2021).
Time to intervene:
A continuous-time approach to network analysis and centrality.
Psychometrika, 87 (1), 214–252.
\doi{10.1007/s11336-021-09767-0}
}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{DeltaBeta}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{MCBeta}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCPhi}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorPhi}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{network}
\keyword{posterior}
