% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_test_MGD.R
\name{calculateParameterDifference}
\alias{calculateParameterDifference}
\title{Internal: Parameter differences across groups}
\usage{
calculateParameterDifference(
  .object     = args_default()$.object,
  .model      = args_default()$.model
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax} indicating which
parameters (i.e., path (\code{~}), loadings (\verb{=~}), or weights (\verb{<~})) should be
compared across groups. Defaults to \code{NULL} in which case all parameters of the model
are compared.}
}
\value{
A list of length equal to the number of possible pairs of
groups in \code{.object} (mathematically, this is n choose 2, i.e., 3 if there are three
groups and 6 if there are 4 groups). Each list elements is itself a list of
three. The first list element contains
the difference between parameter estimates of the structural model, the second
list element the difference between estimated loadings, and the third
the difference between estimated weights.
}
\description{
Calculate the difference between one or more paramater estimates across
all possible pairs of groups (data sets) in \code{.object}.
}
\keyword{internal}
