% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_arguments.R
\name{args_csem_dotdotdot}
\alias{args_csem_dotdotdot}
\title{Internal: Complete list of csem()'s ... arguments}
\arguments{
\item{.approach_cor_robust}{Character string. Approach used to obtain a robust
indicator correlation matrix. One of: "\emph{none}" in which case the standard
Bravais-Person correlation is used,
"\emph{spearman}" for the Spearman rank correlation, or
"\emph{mcd}" via \code{\link[MASS:cov.rob]{MASS::cov.rob()}} for a robust correlation matrix.
Defaults to "\emph{none}". Note that many postestimation procedures (such as
\code{\link[=testOMF]{testOMF()}} or \code{\link[=fit]{fit()}} implicitly assume a continuous
indicator correlation matrix (e.g. Bravais-Pearson correlation matrix).
Only use if you know what you are doing.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.dominant_indicators}{A character vector of \code{"construct_name" = "indicator_name"} pairs,
where \code{"indicator_name"} is a character string giving the name of the dominant indicator
and \code{"construct_name"} a character string of the corresponding construct name.
Dominant indicators may be specified for a subset of the constructs.
Default to \code{NULL}.}

\item{.estimate_structural}{Logical. Should the structural coefficients
be estimated? Defaults to \code{TRUE}.}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.PLS_modes}{Either a named list specifying the mode that should be used for
each construct in the form \code{"construct_name" = mode}, a single character
string giving the mode that should be used for all constructs, or \code{NULL}.
Possible choices for \code{mode} are: "\emph{modeA}", "\emph{modeB}", "\emph{modeBNNLS}",
"\emph{unit}", "\emph{PCA}", a single integer or
a vector of fixed weights of the same length as there are indicators for the
construct given by \code{"construct_name"}. If only a single number is provided this is identical to
using unit weights, as weights are rescaled such that the related composite
has unit variance.  Defaults to \code{NULL}.
If \code{NULL} the appropriate mode according to the type
of construct used is chosen. Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.PLS_ignore_structural_model}{Logical. Should the structural model be ignored
when calculating the inner weights of the PLS-PM algorithm? Defaults to \code{FALSE}.
Ignored if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_weight_scheme_inner}{Character string. The inner weighting scheme
used by PLS-PM. One of: "\emph{centroid}", "\emph{factorial}", or "\emph{path}".
Defaults to "\emph{path}". Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.PLS_approach_cf}{Character string. Approach used to obtain the correction
factors for PLSc. One of: "\emph{dist_squared_euclid}", "\emph{dist_euclid_weighted}",
"\emph{fisher_transformed}", "\emph{mean_arithmetic}", "\emph{mean_geometric}", "\emph{mean_harmonic}",
"\emph{geo_of_harmonic}". Defaults to "\emph{dist_squared_euclid}".
Ignored if \code{.disattenuate = FALSE} or if \code{.approach_weights} is not PLS-PM.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\description{
A complete alphabetical list of all possible arguments accepted by \code{csem()}'s \code{...}
(dotdotdot) argument.
}
\details{
Most arguments supplied to the \code{...} argument of \code{csem()} are only
accepted by a subset of the functions called by \code{csem()}. The following
list shows which argument is passed to which (internal) function:
\describe{
\item{.approach_cor_robust}{Accepted by/Passed down to: \code{\link[=calculateIndicatorCor]{calculateIndicatorCor()}}}
\item{.conv_criterion}{Accepted by/Passed down to: \code{\link[=calculateWeightsPLS]{calculateWeightsPLS()}},
\code{\link[=calculateWeightsGSCA]{calculateWeightsGSCA()}}, \code{\link[=calculateWeightsGSCAm]{calculateWeightsGSCAm()}} and subsequently
\code{\link[=checkConvergence]{checkConvergence()}}.}
\item{.dominant_indicators}{Accepted by/Passed down to: \code{\link[=setDominantIndicator]{setDominantIndicator()}}}
\item{.estimate_structural}{Accepted by/Passed down to: \code{\link[=foreman]{foreman()}}}
\item{.iter_max}{Accepted by/Passed down to: \code{\link[=calculateWeightsPLS]{calculateWeightsPLS()}},
\code{\link[=calculateWeightsGSCA]{calculateWeightsGSCA()}}, \code{\link[=calculateWeightsGSCAm]{calculateWeightsGSCAm()}}}
\item{.PLS_modes, .PLS_ignore_structural_model, .PLS_weight_scheme_inner, .PLS_approach_cf}{
Accepted by/Passed down to: \code{\link[=calculateWeightsPLS]{calculateWeightsPLS()}}}
\item{.tolerance}{Accepted by/Passed down to: \code{\link[=calculateWeightsPLS]{calculateWeightsPLS()}},
\code{\link[=calculateWeightsGSCA]{calculateWeightsGSCA()}}, \code{\link[=calculateWeightsGSCAm]{calculateWeightsGSCAm()}}, \code{\link[=calculateWeightsUnit]{calculateWeightsUnit()}}}
}
}
\keyword{internal}
