% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{cTF}
\alias{cTF}
\title{Construct cTF object}
\usage{
cTF(dat_tf)
}
\arguments{
\item{dat_tf}{A \code{data.frame} such as this returned by calling
\link{get_tf}.}
}
\value{
An S3 object of class \code{cTF}
}
\description{
Constructs an S3 object called cTF contains data returned by calling
\link{get_tf}. Used to define methods for printing and visualizing
transcription factors-gene expression correlations.
}
\examples{
# load required libraries
library(RSQLite)
library(cRegulome)

# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- dbConnect(SQLite(), fl)

# enter a custom query with different arguments
dat <- get_tf(conn,
              tf = 'LEF1',
              study = 'STES*',
              min_abs_cor = .3,
              max_num = 5)

# make a cTF object   
ctf <- cTF(dat)

}
