% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setdata.R
\name{c3d_setdata}
\alias{c3d_setdata}
\title{Write data to a c3d object}
\usage{
c3d_setdata(x, newdata = NULL, newanalog = NULL)
}
\arguments{
\item{x}{A \code{c3d} object to be modified.}

\item{newdata}{The new point data that should be written to the \code{c3d} object.
Usually a data frame of the class \code{c3d_data} as it is generated by
\code{\link[=c3d_data]{c3d_data()}}. Defaults to \code{NULL}, which means that the point data will
remain unchanged. The new point data can be in any format (wide, long,
longest), but take care that the conventions of the format are met (see
\code{\link[=c3d_data]{c3d_data()}} for details).}

\item{newanalog}{The new analog data that should be written to the \code{c3d}
object. Usually a data frame of the class \code{c3d_analog} as it is generated
by \code{\link[=c3d_analog]{c3d_analog()}}. Defaults to \code{NULL}, which means that the analog data
will remain unchanged.}
}
\value{
The modified c3d object.
}
\description{
Set new data to an existing c3d object.
}
\details{
This is a basic helper function to allow the modification of data within the
\code{c3dr} package for later export. The function call updates the data (point
and/or analog) and the appropriate parameters and header sections. Note that
not all parameters can be updated based on insufficient information. For
example, when using \code{c3d_setdata()} for updating the point data, the point
label parameter gets updated (based on the column headers), but the point
label descriptions will be unmodified. This can create minor inconsistencies
in the resulting c3d object, which in the worst case can lead to corrupt data
after export with \code{\link[=c3d_write]{c3d_write()}}. If you plan heavy modifications of the data
before export make sure to manually check and update all relevant parameters
as well as the residual data after calling \code{c3d_setdata()}.
}
\examples{
# Import example data
d <- c3d_read(c3d_example())

# remove last frame from point data and analog data (10 subframes for analog)
d_cut <- c3d_data(d)[-340, ]
a_cut <- c3d_analog(d)[-(3391:3400), ]

# write the new c3d object
d_new <- c3d_setdata(d, newdata = d_cut, newanalog = a_cut)
d_new

}
