% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c14_date_list_enforce_types.R
\name{enforce_types}
\alias{enforce_types}
\alias{enforce_types.default}
\alias{enforce_types.c14_date_list}
\title{Enforce variable types in a \strong{c14_date_list}}
\usage{
enforce_types(x, suppress_na_introduced_warnings = TRUE)

\method{enforce_types}{default}(x,
  suppress_na_introduced_warnings = TRUE)

\method{enforce_types}{c14_date_list}(x,
  suppress_na_introduced_warnings = TRUE)
}
\arguments{
\item{x}{an object of class c14_date_list}

\item{suppress_na_introduced_warnings}{suppress warnings caused by data removal in
type transformation due to wrong database entries (such as text in a number column)}
}
\value{
an object of class c14_date_list
}
\description{
Enforce variable types in a \strong{c14_date_list} and remove
everything that doesn't fit (e.g. text in a number field).
See the
\href{https://github.com/ISAAKiel/c14bazAAR/blob/master/data-raw/variable_reference.csv}{variable_reference}
table for a documentation of the variable types.
\code{enforce_types()} is called in \code{c14bazAAR::as.c14_date_list()}.
}
