% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-models.R
\name{bvar_adding_dummy}
\alias{bvar_adding_dummy}
\title{Adding Dummy Observations}
\description{
This page notes how to define dummy observation matrices in Bayesian VAR and VHAR models.
}
\section{Bayesian VAR}{
Consider BVAR and its hyperparameters in \code{\link[=set_bvar]{set_bvar()}}.
\itemize{
\item \code{sigma}: \eqn{\sigma_1, \ldots, \sigma_m}
\item \code{lambda}: \eqn{\lambda}
\item \code{delta}: \eqn{\delta_1, \ldots, \delta_m}
\item \code{eps}: \eqn{\epsilon}
}

This package implements adding-dummy-observations approach of Bańbura et al. (2010).
Let \eqn{J_p = diag(1, 2, \ldots, p)}.
For each response and design matrix \eqn{Y_0} and \eqn{X_0}, we define dummy observation named by \eqn{Y_p} and \eqn{X_p}.
Response dummy matrix \eqn{Y_p} is (m + k) x m matrix:
\deqn{
  Y_p = \left[\begin{array}{c}
diag\left( \delta_1 \sigma_1, \ldots, \delta_m \sigma_m \right) / \lambda \\
0_{m(p - 1) \times m} \\ \hline
diag\left( \sigma_1, \ldots, \sigma_m \right) \\ \hline
0_m^\intercal
\end{array}\right]
}
Design dummy matrix \eqn{X_p} is (m + k) x k matrix:
\deqn{
  X_p = \left[\begin{array}{c|c}
J_p \otimes diag\left( \sigma_1, \ldots, \sigma_m \right) / \lambda & 0_{mp} \\ \hline
0_{m \times mp} & 0_m \\ \hline
0_{mp}^\intercal & \epsilon
\end{array}\right]
}

These two matrices define Minnesota prior distribution of BVAR.
}

\section{Bayesian VHAR}{
Consider BVHAR and its hyperparameter in \code{\link[=set_bvhar]{set_bvhar()}}.
First, VAR-type minnesota prior:
\itemize{
\item \code{sigma}: \eqn{\sigma_1, \ldots, \sigma_m}
\item \code{lambda}: \eqn{\lambda}
\item \code{delta}: \eqn{\delta_1, \ldots, \delta_m}
\item \code{eps}: \eqn{\epsilon}
For response matrix \eqn{Y_0}, define (m + h) x m matrix \eqn{Y_{HAR}}
\deqn{
  Y_{HAR} = \left[\begin{array}{c}
  diag\left( \delta_1 \sigma_1, \ldots, \delta_m \sigma_m \right) / \lambda \\
  0_{2m \times m} \\ \hline
  diag\left( \sigma_1, \ldots, \sigma_m \right) \\ \hline
  0_m^\intercal
\end{array}\right]
}
For design matrix \eqn{X_0}, define (m + h) x h matrix \eqn{X_{HAR}}
\deqn{
  X_{HAR} = \left[\begin{array}{c|c}
  J_3 \otimes diag\left( \sigma_1, \ldots, \sigma_m \right) / \lambda & 0_{3m} \\ \hline
  0_{m \times 3m} & 0_m \\ \hline
  0_{3m}^\intercal & \epsilon
\end{array}\right]
}
In case of VHAR-type minnesota prior, \code{delta} is replaced with the following three:
\item \code{daily}: \eqn{d_1, \ldots, d_m}
\item \code{weekly}: \eqn{w_1, \ldots, w_m}
\item \code{monthly}: \eqn{m_1, \ldots, m_m}
and \eqn{Y_{HAR}} is changed.
\deqn{
  Y_{HAR} = \left[\begin{array}{c}
  diag\left( d_1 \sigma_1, \ldots, d_m \sigma_m \right) / \lambda \\
  diag\left( w_1 \sigma_1, \ldots, w_m \sigma_m \right) / \lambda \\
  diag\left( m_1 \sigma_1, \ldots, m_m \sigma_m \right) / \lambda \\ \hline
  diag\left( \sigma_1, \ldots, \sigma_m \right) \\ \hline
  0_m^\intercal
\end{array}\right]
}
}

These two dummy matrices define minnesota prior distribution of BVHAR.
}

\references{
Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).
}
\keyword{internal}
