% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-ssvs.R, R/print-bvharsp.R
\name{bvhar_ssvs}
\alias{bvhar_ssvs}
\alias{print.bvharssvs}
\alias{knit_print.bvharssvs}
\title{Fitting Bayesian VHAR of SSVS Prior}
\usage{
bvhar_ssvs(
  y,
  har = c(5, 22),
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = choose_ssvs(y = y, ord = har, type = "VHAR", param = c(0.1, 10),
    include_mean = include_mean, gamma_param = c(0.01, 0.01), mean_non = 0, sd_non = 0.1),
  init_spec = init_ssvs(type = "auto"),
  include_mean = TRUE,
  minnesota = c("no", "short", "longrun"),
  verbose = FALSE
)

\method{print}{bvharssvs}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvharssvs(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of warm-up (burn-in). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A SSVS model specification by \code{\link[=set_ssvs]{set_ssvs()}}. By default, use a default semiautomatic approach \code{\link[=choose_ssvs]{choose_ssvs()}}.}

\item{init_spec}{SSVS initialization specification by \code{\link[=init_ssvs]{init_ssvs()}}. By default, use OLS for coefficient and cholesky factor while 1 for dummies.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). Two type: \code{"short"} type and \code{"longrun"} type. By default, \code{"no"}.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{x}{\code{bvharssvs} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvhar_ssvs} returns an object named \code{bvharssvs} \link{class}.
It is a list with the following components:

\describe{
\item{phi_record}{MCMC trace for vectorized coefficients (phi \eqn{\phi}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{eta_record}{MCMC trace for upper triangular element of cholesky factor (eta \eqn{\eta}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{psi_record}{MCMC trace for diagonal element of cholesky factor (psi \eqn{\psi}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{omega_record}{MCMC trace for indicator variable for \eqn{eta} (omega \eqn{\omega}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{gamma_record}{MCMC trace for indicator variable for \eqn{alpha} (gamma \eqn{\gamma}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{chol_record}{MCMC trace for cholesky factor matrix \eqn{\Psi} with \link{list} format.}
\item{ols_coef}{OLS estimates for VAR coefficients.}
\item{ols_cholesky}{OLS estimates for cholesky factor}
\item{coefficients}{Posterior mean of VAR coefficients.}
\item{omega_posterior}{Posterior mean of omega}
\item{pip}{Posterior inclusion probability}
\item{param}{\link[posterior:draws_df]{posterior::draws_df} with every variable: alpha, eta, psi, omega, and gamma}
\item{chol_posterior}{Posterior mean of cholesky factor matrix}
\item{covmat}{Posterior mean of covariance matrix}
\item{df}{Numer of Coefficients: \verb{3m + 1} or \verb{3m}}
\item{p}{3 (The number of terms. It contains this element for usage in other functions.)}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{"VHAR_SSVS"}}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{spec}{SSVS specification defined by \code{\link[=set_ssvs]{set_ssvs()}}}
\item{init}{Initial specification defined by \code{\link[=init_ssvs]{init_ssvs()}}}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{chain}{The numer of chains}
\item{HARtrans}{VHAR linear transformation matrix}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
}
\description{
This function fits BVAR(p) with stochastic search variable selection (SSVS) prior.
}
\details{
SSVS prior gives prior to parameters \eqn{\alpha = vec(A)} (VAR coefficient) and \eqn{\Sigma_e^{-1} = \Psi \Psi^T} (residual covariance).

\deqn{\alpha_j \mid \gamma_j \sim (1 - \gamma_j) N(0, \kappa_{0j}^2) + \gamma_j N(0, \kappa_{1j}^2)}
\deqn{\gamma_j \sim Bernoulli(q_j)}

and for upper triangular matrix \eqn{\Psi},

\deqn{\psi_{jj}^2 \sim Gamma(shape = a_j, rate = b_j)}
\deqn{\psi_{ij} \mid w_{ij} \sim (1 - w_{ij}) N(0, \kappa_{0,ij}^2) + w_{ij} N(0, \kappa_{1,ij}^2)}
\deqn{w_{ij} \sim Bernoulli(q_{ij})}

Gibbs sampler is used for the estimation.
See \link{ssvs_bvar_algo} how it works.
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881–889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
\seealso{
\itemize{
\item Vectorization formulation \link{var_vec_formulation}
\item Gibbs sampler algorithm \link{ssvs_bvar_algo}
}
}
