% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bvarprd.R
\name{plot.bvarprd}
\alias{plot.bvarprd}
\title{Plotting Forecasts of BVAR Models}
\usage{
\method{plot}{bvarprd}(x, ...)
}
\arguments{
\item{x}{an object of class "bvarprd", usually, a result of a call to \code{\link{predict.bvar}}.}

\item{...}{further graphical parameters.}
}
\description{
A plot function for objects of class \code{"bvarprd"}.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Generate model data
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

# Calculate forecasts
pred <- predict(object, new_D = rep(1, 10))

# Plot forecasts
plot(pred)

}
