% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_priors.R
\name{add_priors}
\alias{add_priors}
\title{Add Priors to Model}
\usage{
add_priors(object, ...)
}
\arguments{
\item{object}{an object of class \code{"bvarmodel"} or \code{"bvecmodel"}.}

\item{...}{arguments passed forward to method.}
}
\description{
Adds prior specifications to a list of models.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Obtain data matrices
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burn-in draws should be much higher.

# Add prior specifications
model <- add_priors(model)

}
