% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minnesota_prior.R
\name{minnesota_prior}
\alias{minnesota_prior}
\title{Minnesota Prior}
\usage{
minnesota_prior(object, kappa0 = 2, kappa1 = 0.5, kappa2 = 0.5,
  kappa3 = 5, max_var = NULL, coint_var = FALSE)
}
\arguments{
\item{object}{an object of class \code{"bvarmodel"}, usually, a result of a call to \code{\link{gen_var}}
or \code{\link{gen_vec}}.}

\item{kappa0}{a numeric specifying the prior standard deviation of coefficients that correspond to
own lags of endogenous variables.}

\item{kappa1}{a numeric specifying the size of the prior standard deviations of endogenous
variables, which do not correspond to own lags, relative to argument \code{kappa0}.}

\item{kappa2}{a numeric specifying the size of the prior standard deviations of exogenous
variables relative to argument \code{kappa0}.}

\item{kappa3}{a numeric specifying the size of the prior standard deviations of deterministic
terms relative to argument \code{kappa0}.}

\item{max_var}{a positive numeric specifying the maximum prior variance that is allowed for
coefficients of non-deterministic variables. If \code{NULL} (default), the prior variances are not limited.}

\item{coint_var}{a logical specifying whether the model is a cointegrated VAR model,
for which the prior means of first own lags should be set to one.}
}
\value{
A list containing a matrix of prior means and the precision matrix.
}
\description{
Calculates the Minnesota prior for a VAR model.
}
\details{
The function calculates the Minnesota prior of a VAR model. For the endogenous variable
\eqn{i} the prior variance of the \eqn{l}th lag of regressor \eqn{j} is obtained as
\deqn{ \left( \frac{\kappa_{0}}{l} \right)^2 \textrm{ for own lags of endogenous variables,}} 
\deqn{ \left( \frac{\kappa_{0} \kappa_{1}}{l} \frac{\sigma_{i}}{\sigma_{j}} \right)^2 \textrm{ for endogenous variables other than own lags,}}
\deqn{ \left( \frac{\kappa_{0} \kappa_{2}}{l} \frac{\sigma_{i}}{\sigma_{j}} \right)^2 \textrm{ for exogenous variables,}}
\deqn{ (\kappa_{0} \kappa_{3})^2 \textrm{ for deterministic terms,}}
where \eqn{\sigma_{i}} is the residual standard deviation of variable \eqn{i} of an unrestricted
OLS estimate of the model. For exogenous variables \eqn{\sigma_{i}} corresponds to the standard
deviation of the original series.

For VEC models the function only provides priors for the non-cointegration part of the model. The
residual standard errors \eqn{\sigma_i} are based on an unrestricted OLS regression of the
endogenous variables on the error correction term and the non-cointegration regressors.
}
\examples{

# Prepare data
data("e1")
data <- diff(log(e1))

# Generate model input
object <- gen_var(data)

# Obtain Minnesota prior
prior <- minnesota_prior(object)

}
\references{
Lütkepohl, H. (2007). \emph{New introduction to multiple time series analysis} (2nd ed.). Berlin: Springer.
}
