% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_var.R
\name{gen_var}
\alias{gen_var}
\title{Vector Autoregressive Model Input}
\usage{
gen_var(data, p = 2, exogen = NULL, s = 2, deterministic = "const",
  seasonal = FALSE)
}
\arguments{
\item{data}{a time-series object of endogenous variables.}

\item{p}{an integer of the lag order (default is \code{p = 2}).}

\item{exogen}{an optional time-series object of external regressors.}

\item{s}{an optional integer of the lag order of the exogenous variables (default is \code{s = 2}).}

\item{deterministic}{a character specifying which deterministic terms should
be included. Available values are \code{"none"}, \code{"const"} (default),
\code{"trend"}, and \code{"both"}.}

\item{seasonal}{logical. If \code{TRUE}, seasonal dummy variables are
generated. The amount of dummies depends on the frequency of the
time-series object provided in \code{data}.}
}
\value{
A list containing the following elements:
\item{Y}{a matrix of endogenous variables.}
\item{Z}{a matrix of regressor variables.}
}
\description{
\code{gen_var} produces the input for the estimation of a vector autoregressive (VAR) model.
}
\details{
The function produces the variable matrices of a vector autoregressive (VAR)
model, which can also include exogenous variables:
\deqn{y_t = \sum_{i=1}^{p} A_i y_{t - i} +
\sum_{i=0}^{s} B_i x_{t - i} +
C D_t + u_t,}
where
\eqn{y_t} is a K-dimensional vector of endogenous variables,
\eqn{A_i} is a \eqn{K \times K} coefficient matrix of endogenous variables,
\eqn{x_t} is an M-dimensional vector of exogenous regressors and
\eqn{B_i} its corresponding \eqn{K \times M} coefficient matrix.
\eqn{D_t} is an N-dimensional vector of deterministic terms and
\eqn{C} its corresponding \eqn{K \times N} coefficient matrix.
\eqn{p} is the lag order of endogenous variables, \eqn{s} is the lag
order of exogenous variables, and \eqn{u_t} is an error term.

In matrix notation the above model can be written as
\deqn{Y = P Z + U,}
where
\eqn{Y} is a \eqn{K \times T} matrix of endogenous variables,
\eqn{Z} is a \eqn{Kp + M(1+s) + N \times T} matrix of regressor variables,
and \eqn{U} is a \eqn{K \times T} matrix of errors. The function \code{gen_var}
generates the matrices \eqn{Y} and \eqn{Z}.
}
\examples{
data("e1")
e1 <- diff(log(e1))
data <- gen_var(e1, p = 2, deterministic = "const")

}
\references{
Lütkepohl, H. (2007). \emph{New introduction to multiple time series analysis} (2nd ed.). Berlin: Springer.
}
