% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_chi}
\alias{pair_chi}
\title{Pearson's Contingency Coefficient for association between  factors.}
\usage{
pair_chi(d, handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{ignored. Pairwise complete observations are used automatically.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with calculated Pearson's contingency coefficient for every factor variable
pair, or NULL if there are not at least two factor variables
}
\description{
Calculates Pearson's Contingency coefficient for every factor variable pair in a dataset.
}
\details{
The Pearson's contingency coefficient is calculated using \code{\link[DescTools]{ContCoef}}.
NAs are automatically handled by pairwise omit.
}
\examples{
 pair_chi(iris)
}
