% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify_volatility.PosteriorBSVAR}
\alias{verify_volatility.PosteriorBSVAR}
\title{Verifies heteroskedasticity of structural shocks equation by equation}
\usage{
\method{verify_volatility}{PosteriorBSVAR}(posterior)
}
\arguments{
\item{posterior}{the \code{posterior} element of the list from the estimation outcome}
}
\value{
Nothing. Just displays a message: The model is homoskedastic.
}
\description{
Displays information that the model is homoskedastic.
}
\examples{
# simple workflow
############################################################
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 5, thin = 1)

# verify heteroskedasticity
sddr           = verify_volatility(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 5, thin = 1) |> 
  verify_volatility() -> sddr
  
}
\references{
Lütkepohl, H., and Woźniak, T., (2020) Bayesian Inference for Structural Vector Autoregressions Identified by Markov-Switching Heteroskedasticity. \emph{Journal of Economic Dynamics and Control} \bold{113}, 103862, \doi{https://doi.org/10.1016/j.jedc.2020.103862}.

Lütkepohl, H., Shang, F., Uzeda, L., and Woźniak, T., (2023) Partial Identification of Heteroskedastic Structural VARs: Theory and Bayesian Inference.
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
