% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popover.R
\name{popover}
\alias{popover}
\alias{toggle_popover}
\alias{update_popover}
\title{Add a popover to a UI element}
\usage{
popover(
  trigger,
  ...,
  title = NULL,
  id = NULL,
  placement = c("auto", "top", "right", "bottom", "left"),
  options = list()
)

toggle_popover(id, show = NULL, session = get_current_session())

update_popover(id, ..., title = NULL, session = get_current_session())
}
\arguments{
\item{trigger}{The UI element to serve as the popover trigger (typically a
\code{\link[shiny:actionButton]{shiny::actionButton()}} or similar). If \code{trigger} renders as multiple HTML
elements (e.g., it's a \code{tagList()}), the last HTML element is used for the
trigger. If the \code{trigger} should contain all of those elements, wrap the
object in a \code{\link[=div]{div()}} or \code{\link[=span]{span()}}.}

\item{...}{UI elements for the popover's body. Character strings are
\link[=htmlEscape]{automatically escaped} unless marked as \code{\link[=HTML]{HTML()}}.}

\item{title}{A title (header) for the popover. To remove a header
with \code{update_popover()}, provide a either an empty string or \code{character(0)}.}

\item{id}{A character string. Required to re-actively respond to the
visibility of the popover (via the \code{input[[id]]} value) and/or update the
visibility/contents of the popover.}

\item{placement}{The placement of the popover relative to its trigger.}

\item{options}{A list of additional
\href{https://getbootstrap.com/docs/5.3/components/popovers/#options}{options}.}

\item{show}{Whether to show (\code{TRUE}) or hide (\code{FALSE}) the popover. The
default (\code{NULL}) will show if currently hidden and hide if currently shown.
Note that a popover will not be shown if the trigger is not visible (e.g.,
it's hidden behind a tab).}

\item{session}{A Shiny session object (the default should almost always be
used).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Display additional information when clicking on a UI element (typically a
button).
}
\section{Functions}{
\itemize{
\item \code{popover()}: Add a popover to a UI element

\item \code{toggle_popover()}: Programmatically show/hide a popover.

\item \code{update_popover()}: Update the contents of a popover.

}}
\section{Closing popovers}{


In addition to clicking the \code{close_button}, popovers can be closed by
pressing the Esc/Space key when the popover (and/or its trigger) is
focused.
}

\section{Theming/Styling}{


Like other bslib components, popovers can be themed by supplying
\href{https://rstudio.github.io/bslib/articles/bs5-variables/index.html#popover-bg}{relevant theming variables}
to \code{\link[=bs_theme]{bs_theme()}},
which effects styling of every popover on the page.
To style a \emph{specific} popover differently from other popover, utilize the \code{customClass} option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{popover(
  "Trigger", "Popover message",
  options = list(customClass = "my-pop")
)
}\if{html}{\out{</div>}}

And then add relevant rules to \code{\link[=bs_theme]{bs_theme()}} via \code{\link[=bs_add_rules]{bs_add_rules()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bs_theme() |> bs_add_rules(".my-pop \{ max-width: none; \}")
}\if{html}{\out{</div>}}
}

\section{Accessibility of Popover Triggers}{


Because the user needs to interact with the \code{trigger} element to see the popover, it's best practice to use an element that is typically accessible via keyboard interactions, like a button or a link.
If you use a non-interactive element, like a \verb{<span>} or text, bslib will automatically add the \code{tabindex="0"} attribute to the trigger element to make sure that users can reach the element with the keyboard.
This means that in most cases you can use any element you want as the trigger.

One place where it's important to consider the accessibility of the trigger is when using an icon without any accompanying text.
In these cases, many R packages that provide icons will create an icon element with the assumption that the icon is decorative, which will make it inaccessible to users of assistive technologies.

When using an icon as the primary trigger, ensure that the icon does not have \code{aria-hidden="true"} or \code{role="presentation"} attributes.
Icon packages typically provide a way to specify a title for the icon, as well as a way to specify that the icon is not decorative.
The title should be a short description of the purpose of the trigger, rather than a description of the icon itself.
\itemize{
\item If you're using \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}, provide a \code{title}.
\item If you're using \code{\link[fontawesome:fa]{fontawesome::fa()}}, set \code{a11y = "sem"} and provide a \code{title}.
}

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{popover(
  bsicons::bs_icon("gear", title = "Settings"),
  title = "Settings",
  sliderInput("n", "Number of points", 1, 100, 50)
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{popover(
  fontawesome::fa("gear", a11y = "sem", title = "Settings"),
  title = "Settings",
  sliderInput("n", "Number of points", 1, 100, 50)
)
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

popover(
  shiny::actionButton("btn", "A button"),
  "Popover body content...",
  title = "Popover title"
)

library(shiny)

ui <- page_fixed(
  card(class = "mt-5",
    card_header(
      popover(
        uiOutput("card_title", inline = TRUE),
        title = "Provide a new title",
        textInput("card_title", NULL, "An editable title")
      )
    ),
    "The card body..."
  )
)

server <- function(input, output) {
  output$card_title <- renderUI({
    list(input$card_title, bsicons::bs_icon("pencil-square"))
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\references{
Popovers are based on \href{https://getbootstrap.com/docs/5.3/components/popovers/}{Bootstrap's Popover component}. See the
bslib website for an \href{https://rstudio.github.io/bslib/articles/tooltips-popovers/index.html}{interactive introduction to tooltips and popovers}.
}
\seealso{
\code{\link[=tooltip]{tooltip()}} provides an alternative way to display informational
text on demand, typically when focusing or hovering over a trigger element.

Other Components: 
\code{\link{accordion}()},
\code{\link{card}()},
\code{\link{tooltip}()},
\code{\link{value_box}()}
}
\concept{Components}
