% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_bscui_attributes.R
\name{update_bscui_attributes}
\alias{update_bscui_attributes}
\title{Update the attributes of bscui elements in 'shiny' app}
\usage{
update_bscui_attributes(
  proxy,
  element_attributes,
  to_ignore = NULL,
  targeted_tags = NULL
)
}
\arguments{
\item{proxy}{a \code{\link{bscui_Proxy}} object}

\item{element_attributes}{a data frame with an \strong{id} column
providing the element identifier and one column per attribute name.}

\item{to_ignore}{of elements to ignore: if those elements are
children of elements to update they won't be updated. This parameter
is not taken into account when there is no "id" column in the element_styles
data frame.}

\item{targeted_tags}{affected tag names. If NULL (default),
the structure_shapes of the \code{\link{bscui}} object}
}
\value{
the provided proxy object
}
\description{
Update the attributes of bscui elements in 'shiny' app
}
\examples{
if(interactive()){
   from_shiny <- new.env()
   shiny::runApp(system.file(
      "examples", "shiny-anatomogram", package = "bscui"
   ))
   for(n in names(from_shiny)){
      bscui(from_shiny[[n]]) |> print()
   }
}
}
