% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedulers.R
\name{schedule_decay_time}
\alias{schedule_decay_time}
\alias{schedule_decay_expo}
\alias{schedule_step}
\alias{schedule_cyclic}
\alias{set_learn_rate}
\title{Change the learning rate over time}
\usage{
schedule_decay_time(epoch, initial = 0.1, decay = 1)

schedule_decay_expo(epoch, initial = 0.1, decay = 1)

schedule_step(epoch, initial = 0.1, reduction = 1/2, steps = 5)

schedule_cyclic(epoch, initial = 0.001, largest = 0.1, step_size = 5)

set_learn_rate(epoch, learn_rate, type = "none", ...)
}
\arguments{
\item{epoch}{An integer for the number of training epochs (zero being the
initial value),}

\item{initial}{A positive numeric value for the starting learning rate.}

\item{decay}{A positive numeric constant for decreasing the rate (see
Details below).}

\item{reduction}{A positive numeric constant stating the proportional decrease
in the learning rate occurring at every \code{steps} epochs.}

\item{steps}{The number of epochs before the learning rate changes.}

\item{largest}{The maximum learning rate in the cycle.}

\item{step_size}{The half-length of a cycle.}

\item{learn_rate}{A constant learning rate (when no scheduler is used),}

\item{type}{A single character value for the type of scheduler. Possible
values are: "decay_time", "decay_expo", "none", "cyclic", and "step".}

\item{...}{Arguments to pass to the individual scheduler functions (e.g.
\code{reduction}).}
}
\value{
A numeric value for the updated learning rate.
}
\description{
Learning rate schedulers alter the learning rate to adjust as training
proceeds. In most cases, the learning rate decreases as epochs increase.
The \verb{schedule_*()} functions are individual schedulers and
\code{\link[=set_learn_rate]{set_learn_rate()}} is a general interface.
}
\details{
The details for how the schedulers change the rates:
\itemize{
\item \code{schedule_decay_time()}: \eqn{rate(epoch) = initial/(1 + decay \times epoch)}
\item \code{schedule_decay_expo()}: \eqn{rate(epoch) = initial\exp(-decay \times epoch)}
\item \code{schedule_step()}: \eqn{rate(epoch) = initial \times reduction^{floor(epoch / steps)}}
\item \code{schedule_cyclic()}: \eqn{cycle = floor( 1 + (epoch / 2 / step size) )},
\eqn{x = abs( ( epoch / step size ) - ( 2 * cycle) + 1 )}, and
\eqn{rate(epoch) = initial + ( largest - initial ) * \max( 0, 1 - x)}
}
}
\examples{
if (rlang::is_installed("purrr")) {
 library(ggplot2)
 library(dplyr)
 library(purrr)

 iters <- 0:50

 bind_rows(
  tibble(epoch = iters, rate = map_dbl(iters, schedule_decay_time), type = "decay_time"),
  tibble(epoch = iters, rate = map_dbl(iters, schedule_decay_expo), type = "decay_expo"),
  tibble(epoch = iters, rate = map_dbl(iters, schedule_step), type = "step"),
  tibble(epoch = iters, rate = map_dbl(iters, schedule_cyclic), type = "cyclic")
 ) \%>\%
  ggplot(aes(epoch, rate)) +
  geom_line() +
  facet_wrap(~ type)

}

}
\seealso{
\code{\link[=brulee_mlp]{brulee_mlp()}}
}
