% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_easystats.R
\name{glance_performance}
\alias{glance_performance}
\title{Model performance summary dataframes using \code{broom} and \code{easystats}.}
\usage{
glance_performance(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A data frame (with one row) and one column per "index".
}
\description{
Computes indices of model performance for regression models.
}
\details{
The function will attempt to get these details either using
\code{\link[broom:reexports]{broom::glance()}} or \code{\link[performance:model_performance]{performance::model_performance()}}. If both function
provide model performance measure summaries, the function will try to
combine them into a single dataframe.
}
\examples{
set.seed(123)
mod <- lm(mpg ~ wt + cyl, data = mtcars)
broomExtra::glance_performance(mod)
}
