% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyz_tidiers.R
\name{xyz_tidiers}
\alias{xyz_tidiers}
\alias{tidy_xyz}
\title{Tidiers for x, y, z lists suitable for persp, image, etc.}
\usage{
tidy_xyz(x, ...)
}
\arguments{
\item{x}{list with components x, y and z}

\item{...}{extra arguments}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns a data frame with columns x, y and z and one row
per value in matrix z.
}
\description{
Tidies lists with components x, y (vector of coordinates) and z (matrix of
values) which are typically used by functions such as
\code{\link[graphics]{persp}} or \code{\link[graphics]{image}} and returned
by interpolation functions such as \code{\link[akima]{interp}}.
}
\examples{

A <- list(x=1:5, y=1:3, z=matrix(runif(5*3), nrow=5))
image(A)
tidy(A)

}
