% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_tidiers.R
\name{glm_tidiers}
\alias{glm_tidiers}
\alias{glance.glm}
\title{Tidying methods for a glm object}
\usage{
\method{glance}{glm}(x, ...)
}
\arguments{
\item{x}{glm object}

\item{...}{extra arguments, not used}
}
\value{
\code{tidy} and \code{augment} return the same values as do
\code{\link{tidy.lm}} and \code{\link{augment.lm}}.

\code{glance} returns a one-row data.frame with the columns
  \item{null.deviance}{the deviance of the null model}
  \item{df.null}{the residual degrees of freedom for the null model}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
Tidy a \code{glm} object. The \code{tidy} and \code{augment} methods are handled
by \link{lm_tidiers}.
}
\examples{

g <- glm(am ~ mpg, mtcars, family = "binomial")
glance(g)

}
\seealso{
\code{\link{tidy.lm}} and \code{\link{augment.lm}}. Also \code{\link{glm}}, which
computes the values reported by the \code{glance} method.
}
