% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grayplot_na.R
\name{grayplot_na}
\alias{grayplot_na}
\title{Scatterplot with missing values indicated}
\usage{
grayplot_na(
  x,
  y = NULL,
  type = "p",
  bgcolor = "gray90",
  v_over_h = FALSE,
  pch = 21,
  bg = "lightblue",
  col = "black",
  force = c("none", "x", "y", "both"),
  ...
)
}
\arguments{
\item{x}{Coordinates of points in the plot}

\item{y}{Coordinates of points in the plot (optional)}

\item{type}{Plot type (points, lines, etc.)}

\item{bgcolor}{Background color}

\item{v_over_h}{If \code{TRUE}, place vertical grid lines on top of
the horizontal ones.}

\item{pch}{point type}

\item{bg}{Background color in points}

\item{col}{Color of outer circle in points}

\item{force}{Indicates whether to force the NA box (on the x-axis,
y-axis, or both) even when there are no missing values.}

\item{...}{Optional graphics arguments}
}
\value{
None.
}
\description{
Scatterplot with a gray background and with points with missing
values shown in separate panels near the margins.
}
\details{
Calls \code{\link[graphics:plot]{graphics::plot()}} with `type="n", then
\code{\link[graphics:rect]{graphics::rect()}} to get the background, and then
\code{\link[graphics:points]{graphics::points()}}.

There are a bunch of hidden graphical arguments you can include:
\code{na.width} controls the proportional width devoted to the NA boxes,
and \code{na.gap} the proportion for the gap between the NA boxes and
the main plot region. \code{mgp.x} and \code{mgp.y} (like \code{mgp}, for
controlling parameters of axis labels, but separate for x- and
y-axis). Also \code{hlines} to indicate locations of of horizontal
gridlines, and \code{hlines.col}, \code{hlines.lwd}, and \code{hlines.lty} to set
their color, width, and type. \code{hlines=NA} suppresses the grid
lines. Similarly \code{vlines}, \code{vlines.col}, \code{vlines.lwd}, and
\code{vlines.lty}. \code{xat} and \code{yat} are for specifying the locations of
x- and y-axis labels, respectively. \code{xat=NA} and \code{yat=NA} indicate
no labels.
}
\examples{
\dontshow{set.seed(97536917)}
n <- 100
x <- rnorm(n)
y <- x+rnorm(n, 0, 0.7)
x[sample(n, 10)] <- NA

grayplot_na(x, y)

grayplot_na(x, y, force="y")

y[sample(n, 10)] <- NA
grayplot_na(x, y)

}
\seealso{
\code{\link[=grayplot]{grayplot()}}, \code{\link[=dotplot]{dotplot()}}
}
\keyword{graphics}
