
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_breath_test_1_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_breath_test_1");
    reader.add_event(76, 76, "end", "model_breath_test_1");
    return reader;
}

class model_breath_test_1 : public prob_grad {
private:
    int n;
    int n_record;
    int student_t_df;
    double dose;
    vector<int> pat_group_i;
    vector_d minute;
    vector_d pdr;
public:
    model_breath_test_1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_breath_test_1(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_breath_test_1_namespace::model_breath_test_1";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
            n_record = int(0);
            vals_i__ = context__.vals_i("n_record");
            pos__ = 0;
            n_record = vals_i__[pos__++];
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "student_t_df", "int", context__.to_vec());
            student_t_df = int(0);
            vals_i__ = context__.vals_i("student_t_df");
            pos__ = 0;
            student_t_df = vals_i__[pos__++];
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec());
            dose = double(0);
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            dose = vals_r__[pos__++];
            current_statement_begin__ = 8;
            validate_non_negative_index("pat_group_i", "n", n);
            context__.validate_dims("data initialization", "pat_group_i", "int", context__.to_vec(n));
            validate_non_negative_index("pat_group_i", "n", n);
            pat_group_i = std::vector<int>(n,int(0));
            vals_i__ = context__.vals_i("pat_group_i");
            pos__ = 0;
            size_t pat_group_i_limit_0__ = n;
            for (size_t i_0__ = 0; i_0__ < pat_group_i_limit_0__; ++i_0__) {
                pat_group_i[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("minute", "n", n);
            context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
            validate_non_negative_index("minute", "n", n);
            minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("minute");
            pos__ = 0;
            size_t minute_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
                minute[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("pdr", "n", n);
            context__.validate_dims("data initialization", "pdr", "vector_d", context__.to_vec(n));
            validate_non_negative_index("pdr", "n", n);
            pdr = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("pdr");
            pos__ = 0;
            size_t pdr_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < pdr_i_vec_lim__; ++i_vec__) {
                pdr[i_vec__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 4;
            check_greater_or_equal(function__,"n",n,0);
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"n_record",n_record,0);
            current_statement_begin__ = 6;
            check_greater_or_equal(function__,"student_t_df",student_t_df,1);
            current_statement_begin__ = 7;
            check_greater_or_equal(function__,"dose",dose,0);
            current_statement_begin__ = 8;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"pat_group_i[k0__]",pat_group_i[k0__],0);
            }
            current_statement_begin__ = 9;
            check_greater_or_equal(function__,"minute",minute,0);
            current_statement_begin__ = 10;
            check_greater_or_equal(function__,"pdr",pdr,-(30));
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 14;
            validate_non_negative_index("m_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 15;
            ++num_params_r__;
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 18;
            validate_non_negative_index("k_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 19;
            ++num_params_r__;
            current_statement_begin__ = 20;
            ++num_params_r__;
            current_statement_begin__ = 22;
            validate_non_negative_index("beta_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 23;
            ++num_params_r__;
            current_statement_begin__ = 24;
            ++num_params_r__;
            current_statement_begin__ = 26;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_breath_test_1() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("m_raw")))
            throw std::runtime_error("variable m_raw missing");
        vals_r__ = context__.vals_r("m_raw");
        pos__ = 0U;
        validate_non_negative_index("m_raw", "n_record", n_record);
        context__.validate_dims("initialization", "m_raw", "vector_d", context__.to_vec(n_record));
        vector_d m_raw(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            m_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(m_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m_raw: ") + e.what());
        }

        if (!(context__.contains_r("mu_m")))
            throw std::runtime_error("variable mu_m missing");
        vals_r__ = context__.vals_r("mu_m");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_m", "double", context__.to_vec());
        double mu_m(0);
        mu_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_m: ") + e.what());
        }

        if (!(context__.contains_r("sigma_m")))
            throw std::runtime_error("variable sigma_m missing");
        vals_r__ = context__.vals_r("sigma_m");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_m", "double", context__.to_vec());
        double sigma_m(0);
        sigma_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_m: ") + e.what());
        }

        if (!(context__.contains_r("k_raw")))
            throw std::runtime_error("variable k_raw missing");
        vals_r__ = context__.vals_r("k_raw");
        pos__ = 0U;
        validate_non_negative_index("k_raw", "n_record", n_record);
        context__.validate_dims("initialization", "k_raw", "vector_d", context__.to_vec(n_record));
        vector_d k_raw(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            k_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(k_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k_raw: ") + e.what());
        }

        if (!(context__.contains_r("mu_k")))
            throw std::runtime_error("variable mu_k missing");
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_k", "double", context__.to_vec());
        double mu_k(0);
        mu_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what());
        }

        if (!(context__.contains_r("sigma_k")))
            throw std::runtime_error("variable sigma_k missing");
        vals_r__ = context__.vals_r("sigma_k");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_k", "double", context__.to_vec());
        double sigma_k(0);
        sigma_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_k: ") + e.what());
        }

        if (!(context__.contains_r("beta_raw")))
            throw std::runtime_error("variable beta_raw missing");
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "n_record", n_record);
        context__.validate_dims("initialization", "beta_raw", "vector_d", context__.to_vec(n_record));
        vector_d beta_raw(static_cast<Eigen::VectorXd::Index>(n_record));
        for (int j1__ = 0U; j1__ < n_record; ++j1__)
            beta_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what());
        }

        if (!(context__.contains_r("mu_beta")))
            throw std::runtime_error("variable mu_beta missing");
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_beta", "double", context__.to_vec());
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_beta")))
            throw std::runtime_error("variable sigma_beta missing");
        vals_r__ = context__.vals_r("sigma_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_beta", "double", context__.to_vec());
        double sigma_beta(0);
        sigma_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_beta: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  m_raw;
            (void) m_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                m_raw = in__.vector_constrain(n_record,lp__);
            else
                m_raw = in__.vector_constrain(n_record);

            T__ mu_m;
            (void) mu_m;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_m = in__.scalar_lb_constrain(0,lp__);
            else
                mu_m = in__.scalar_lb_constrain(0);

            T__ sigma_m;
            (void) sigma_m;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_m = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_m = in__.scalar_lb_constrain(0);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  k_raw;
            (void) k_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                k_raw = in__.vector_constrain(n_record,lp__);
            else
                k_raw = in__.vector_constrain(n_record);

            T__ mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.scalar_lb_constrain(0,lp__);
            else
                mu_k = in__.scalar_lb_constrain(0);

            T__ sigma_k;
            (void) sigma_k;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_k = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_k = in__.scalar_lb_constrain(0);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.vector_constrain(n_record,lp__);
            else
                beta_raw = in__.vector_constrain(n_record);

            T__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_beta = in__.scalar_lb_constrain(0,lp__);
            else
                mu_beta = in__.scalar_lb_constrain(0);

            T__ sigma_beta;
            (void) sigma_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_beta = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_beta = in__.scalar_lb_constrain(0);

            T__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0,lp__);
            else
                sigma = in__.scalar_lb_constrain(0);


            // transformed parameters
            current_statement_begin__ = 31;
            validate_non_negative_index("m", "n_record", n_record);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  m(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) m;  // dummy to suppress unused var warning

            stan::math::initialize(m, DUMMY_VAR__);
            stan::math::fill(m,DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("k", "n_record", n_record);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  k(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) k;  // dummy to suppress unused var warning

            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k,DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("beta", "n_record", n_record);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 36;
            stan::math::assign(m, add(mu_m,multiply(sigma_m,m_raw)));
            current_statement_begin__ = 37;
            stan::math::assign(k, add(mu_k,multiply(sigma_k,k_raw)));
            current_statement_begin__ = 38;
            stan::math::assign(beta, add(mu_beta,multiply(sigma_beta,beta_raw)));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < n_record; ++i0__) {
                if (stan::math::is_uninitialized(m(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: m" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < n_record; ++i0__) {
                if (stan::math::is_uninitialized(k(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < n_record; ++i0__) {
                if (stan::math::is_uninitialized(beta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 31;
            check_greater_or_equal(function__,"m",m,0);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__,"k",k,0);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__,"beta",beta,0);

            // model body

            current_statement_begin__ = 43;
            lp_accum__.add(normal_log<propto__>(m_raw, 0, 1));
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(mu_m, 40, 30));
            current_statement_begin__ = 45;
            lp_accum__.add(cauchy_log<propto__>(sigma_m, 0, 10));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(k_raw, 0, 1));
            current_statement_begin__ = 48;
            lp_accum__.add(lognormal_log<propto__>(mu_k, -(5), 2));
            current_statement_begin__ = 49;
            lp_accum__.add(lognormal_log<propto__>(sigma_k, -(7), 2));
            current_statement_begin__ = 51;
            lp_accum__.add(normal_log<propto__>(beta_raw, 0, 1));
            current_statement_begin__ = 52;
            lp_accum__.add(normal_log<propto__>(mu_beta, 2, 0.5));
            current_statement_begin__ = 53;
            lp_accum__.add(cauchy_log<propto__>(sigma_beta, 0, 2));
            current_statement_begin__ = 55;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            {
            current_statement_begin__ = 57;
            validate_non_negative_index("pdr1", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pdr1(static_cast<Eigen::VectorXd::Index>(n));
            (void) pdr1;  // dummy to suppress unused var warning

            stan::math::initialize(pdr1, DUMMY_VAR__);
            stan::math::fill(pdr1,DUMMY_VAR__);


            current_statement_begin__ = 58;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 59;
                int rec(0);
                (void) rec;  // dummy to suppress unused var warning

                stan::math::fill(rec, std::numeric_limits<int>::min());
                current_statement_begin__ = 60;
                T__ mn;
                (void) mn;  // dummy to suppress unused var warning

                stan::math::initialize(mn, DUMMY_VAR__);
                stan::math::fill(mn,DUMMY_VAR__);
                current_statement_begin__ = 61;
                T__ exp_ktn;
                (void) exp_ktn;  // dummy to suppress unused var warning

                stan::math::initialize(exp_ktn, DUMMY_VAR__);
                stan::math::fill(exp_ktn,DUMMY_VAR__);
                current_statement_begin__ = 62;
                T__ kn;
                (void) kn;  // dummy to suppress unused var warning

                stan::math::initialize(kn, DUMMY_VAR__);
                stan::math::fill(kn,DUMMY_VAR__);
                current_statement_begin__ = 63;
                T__ betan;
                (void) betan;  // dummy to suppress unused var warning

                stan::math::initialize(betan, DUMMY_VAR__);
                stan::math::fill(betan,DUMMY_VAR__);


                current_statement_begin__ = 64;
                stan::math::assign(rec, get_base1(pat_group_i,i,"pat_group_i",1));
                current_statement_begin__ = 65;
                stan::math::assign(mn, get_base1(m,rec,"m",1));
                current_statement_begin__ = 66;
                stan::math::assign(kn, get_base1(k,rec,"k",1));
                current_statement_begin__ = 67;
                stan::math::assign(exp_ktn, exp((-(kn) * get_base1(minute,i,"minute",1))));
                current_statement_begin__ = 68;
                stan::math::assign(betan, get_base1(beta,rec,"beta",1));
                current_statement_begin__ = 69;
                stan::math::assign(get_base1_lhs(pdr1,i,"pdr1",1), (((((dose * mn) * kn) * betan) * exp_ktn) * pow((1 - exp_ktn),(betan - 1))));
                }
            }
            current_statement_begin__ = 71;
            if (as_bool(logical_lt(student_t_df,10))) {
                current_statement_begin__ = 72;
                lp_accum__.add(student_t_log<propto__>(pdr, student_t_df, pdr1, sigma));
            } else {
                current_statement_begin__ = 74;
                lp_accum__.add(normal_log<propto__>(pdr, pdr1, sigma));
            }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("m_raw");
        names__.push_back("mu_m");
        names__.push_back("sigma_m");
        names__.push_back("k_raw");
        names__.push_back("mu_k");
        names__.push_back("sigma_k");
        names__.push_back("beta_raw");
        names__.push_back("mu_beta");
        names__.push_back("sigma_beta");
        names__.push_back("sigma");
        names__.push_back("m");
        names__.push_back("k");
        names__.push_back("beta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_breath_test_1_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d m_raw = in__.vector_constrain(n_record);
        double mu_m = in__.scalar_lb_constrain(0);
        double sigma_m = in__.scalar_lb_constrain(0);
        vector_d k_raw = in__.vector_constrain(n_record);
        double mu_k = in__.scalar_lb_constrain(0);
        double sigma_k = in__.scalar_lb_constrain(0);
        vector_d beta_raw = in__.vector_constrain(n_record);
        double mu_beta = in__.scalar_lb_constrain(0);
        double sigma_beta = in__.scalar_lb_constrain(0);
        double sigma = in__.scalar_lb_constrain(0);
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(m_raw[k_0__]);
            }
        vars__.push_back(mu_m);
        vars__.push_back(sigma_m);
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(k_raw[k_0__]);
            }
        vars__.push_back(mu_k);
        vars__.push_back(sigma_k);
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(beta_raw[k_0__]);
            }
        vars__.push_back(mu_beta);
        vars__.push_back(sigma_beta);
        vars__.push_back(sigma);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 31;
            validate_non_negative_index("m", "n_record", n_record);
            vector_d m(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) m;  // dummy to suppress unused var warning

            stan::math::initialize(m, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(m,DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("k", "n_record", n_record);
            vector_d k(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) k;  // dummy to suppress unused var warning

            stan::math::initialize(k, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(k,DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("beta", "n_record", n_record);
            vector_d beta(static_cast<Eigen::VectorXd::Index>(n_record));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 36;
            stan::math::assign(m, add(mu_m,multiply(sigma_m,m_raw)));
            current_statement_begin__ = 37;
            stan::math::assign(k, add(mu_k,multiply(sigma_k,k_raw)));
            current_statement_begin__ = 38;
            stan::math::assign(beta, add(mu_beta,multiply(sigma_beta,beta_raw)));

            // validate transformed parameters
            current_statement_begin__ = 31;
            check_greater_or_equal(function__,"m",m,0);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__,"k",k,0);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__,"beta",beta,0);

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(m[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(k[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_record; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_breath_test_1";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_record; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_breath_test_group_1_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_breath_test_group_1");
    reader.add_event(82, 82, "end", "model_breath_test_group_1");
    return reader;
}

class model_breath_test_group_1 : public prob_grad {
private:
    int n;
    int n_pat;
    int n_group;
    double dose;
    double student_t_df;
    vector<int> pat_i;
    vector<int> group_i;
    vector_d minute;
    vector_d pdr;
public:
    model_breath_test_group_1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_breath_test_group_1(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_breath_test_group_1_namespace::model_breath_test_group_1";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "n_pat", "int", context__.to_vec());
            n_pat = int(0);
            vals_i__ = context__.vals_i("n_pat");
            pos__ = 0;
            n_pat = vals_i__[pos__++];
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "n_group", "int", context__.to_vec());
            n_group = int(0);
            vals_i__ = context__.vals_i("n_group");
            pos__ = 0;
            n_group = vals_i__[pos__++];
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec());
            dose = double(0);
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            dose = vals_r__[pos__++];
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "student_t_df", "double", context__.to_vec());
            student_t_df = double(0);
            vals_r__ = context__.vals_r("student_t_df");
            pos__ = 0;
            student_t_df = vals_r__[pos__++];
            current_statement_begin__ = 10;
            validate_non_negative_index("pat_i", "n", n);
            context__.validate_dims("data initialization", "pat_i", "int", context__.to_vec(n));
            validate_non_negative_index("pat_i", "n", n);
            pat_i = std::vector<int>(n,int(0));
            vals_i__ = context__.vals_i("pat_i");
            pos__ = 0;
            size_t pat_i_limit_0__ = n;
            for (size_t i_0__ = 0; i_0__ < pat_i_limit_0__; ++i_0__) {
                pat_i[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("group_i", "n", n);
            context__.validate_dims("data initialization", "group_i", "int", context__.to_vec(n));
            validate_non_negative_index("group_i", "n", n);
            group_i = std::vector<int>(n,int(0));
            vals_i__ = context__.vals_i("group_i");
            pos__ = 0;
            size_t group_i_limit_0__ = n;
            for (size_t i_0__ = 0; i_0__ < group_i_limit_0__; ++i_0__) {
                group_i[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("minute", "n", n);
            context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
            validate_non_negative_index("minute", "n", n);
            minute = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("minute");
            pos__ = 0;
            size_t minute_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < minute_i_vec_lim__; ++i_vec__) {
                minute[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 13;
            validate_non_negative_index("pdr", "n", n);
            context__.validate_dims("data initialization", "pdr", "vector_d", context__.to_vec(n));
            validate_non_negative_index("pdr", "n", n);
            pdr = vector_d(static_cast<Eigen::VectorXd::Index>(n));
            vals_r__ = context__.vals_r("pdr");
            pos__ = 0;
            size_t pdr_i_vec_lim__ = n;
            for (size_t i_vec__ = 0; i_vec__ < pdr_i_vec_lim__; ++i_vec__) {
                pdr[i_vec__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 5;
            check_greater_or_equal(function__,"n",n,0);
            current_statement_begin__ = 6;
            check_greater_or_equal(function__,"n_pat",n_pat,0);
            current_statement_begin__ = 7;
            check_greater_or_equal(function__,"n_group",n_group,0);
            current_statement_begin__ = 8;
            check_greater_or_equal(function__,"dose",dose,0);
            current_statement_begin__ = 9;
            check_greater_or_equal(function__,"student_t_df",student_t_df,2);
            current_statement_begin__ = 10;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"pat_i[k0__]",pat_i[k0__],0);
            }
            current_statement_begin__ = 11;
            for (int k0__ = 0; k0__ < n; ++k0__) {
                check_greater_or_equal(function__,"group_i[k0__]",group_i[k0__],0);
            }
            current_statement_begin__ = 12;
            check_greater_or_equal(function__,"minute",minute,0);
            current_statement_begin__ = 13;
            check_greater_or_equal(function__,"pdr",pdr,-(30));
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 17;
            validate_non_negative_index("m_pat_raw", "n_pat", n_pat);
            num_params_r__ += n_pat;
            current_statement_begin__ = 18;
            validate_non_negative_index("m_group", "n_group", n_group);
            num_params_r__ += n_group;
            current_statement_begin__ = 19;
            ++num_params_r__;
            current_statement_begin__ = 20;
            ++num_params_r__;
            current_statement_begin__ = 22;
            validate_non_negative_index("k_pat_raw", "n_pat", n_pat);
            num_params_r__ += n_pat;
            current_statement_begin__ = 23;
            validate_non_negative_index("k_group", "n_group", n_group);
            num_params_r__ += n_group;
            current_statement_begin__ = 24;
            ++num_params_r__;
            current_statement_begin__ = 25;
            ++num_params_r__;
            current_statement_begin__ = 27;
            validate_non_negative_index("beta_pat_raw", "n_pat", n_pat);
            num_params_r__ += n_pat;
            current_statement_begin__ = 28;
            validate_non_negative_index("beta_group", "n_group", n_group);
            num_params_r__ += n_group;
            current_statement_begin__ = 29;
            ++num_params_r__;
            current_statement_begin__ = 30;
            ++num_params_r__;
            current_statement_begin__ = 32;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_breath_test_group_1() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("m_pat_raw")))
            throw std::runtime_error("variable m_pat_raw missing");
        vals_r__ = context__.vals_r("m_pat_raw");
        pos__ = 0U;
        validate_non_negative_index("m_pat_raw", "n_pat", n_pat);
        context__.validate_dims("initialization", "m_pat_raw", "vector_d", context__.to_vec(n_pat));
        vector_d m_pat_raw(static_cast<Eigen::VectorXd::Index>(n_pat));
        for (int j1__ = 0U; j1__ < n_pat; ++j1__)
            m_pat_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(m_pat_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m_pat_raw: ") + e.what());
        }

        if (!(context__.contains_r("m_group")))
            throw std::runtime_error("variable m_group missing");
        vals_r__ = context__.vals_r("m_group");
        pos__ = 0U;
        validate_non_negative_index("m_group", "n_group", n_group);
        context__.validate_dims("initialization", "m_group", "vector_d", context__.to_vec(n_group));
        vector_d m_group(static_cast<Eigen::VectorXd::Index>(n_group));
        for (int j1__ = 0U; j1__ < n_group; ++j1__)
            m_group(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(m_group);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m_group: ") + e.what());
        }

        if (!(context__.contains_r("sigma_m_pat")))
            throw std::runtime_error("variable sigma_m_pat missing");
        vals_r__ = context__.vals_r("sigma_m_pat");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_m_pat", "double", context__.to_vec());
        double sigma_m_pat(0);
        sigma_m_pat = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_m_pat);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_m_pat: ") + e.what());
        }

        if (!(context__.contains_r("mu_m")))
            throw std::runtime_error("variable mu_m missing");
        vals_r__ = context__.vals_r("mu_m");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_m", "double", context__.to_vec());
        double mu_m(0);
        mu_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_m: ") + e.what());
        }

        if (!(context__.contains_r("k_pat_raw")))
            throw std::runtime_error("variable k_pat_raw missing");
        vals_r__ = context__.vals_r("k_pat_raw");
        pos__ = 0U;
        validate_non_negative_index("k_pat_raw", "n_pat", n_pat);
        context__.validate_dims("initialization", "k_pat_raw", "vector_d", context__.to_vec(n_pat));
        vector_d k_pat_raw(static_cast<Eigen::VectorXd::Index>(n_pat));
        for (int j1__ = 0U; j1__ < n_pat; ++j1__)
            k_pat_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(k_pat_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k_pat_raw: ") + e.what());
        }

        if (!(context__.contains_r("k_group")))
            throw std::runtime_error("variable k_group missing");
        vals_r__ = context__.vals_r("k_group");
        pos__ = 0U;
        validate_non_negative_index("k_group", "n_group", n_group);
        context__.validate_dims("initialization", "k_group", "vector_d", context__.to_vec(n_group));
        vector_d k_group(static_cast<Eigen::VectorXd::Index>(n_group));
        for (int j1__ = 0U; j1__ < n_group; ++j1__)
            k_group(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(k_group);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k_group: ") + e.what());
        }

        if (!(context__.contains_r("sigma_k_pat")))
            throw std::runtime_error("variable sigma_k_pat missing");
        vals_r__ = context__.vals_r("sigma_k_pat");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_k_pat", "double", context__.to_vec());
        double sigma_k_pat(0);
        sigma_k_pat = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_k_pat);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_k_pat: ") + e.what());
        }

        if (!(context__.contains_r("mu_k")))
            throw std::runtime_error("variable mu_k missing");
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_k", "double", context__.to_vec());
        double mu_k(0);
        mu_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what());
        }

        if (!(context__.contains_r("beta_pat_raw")))
            throw std::runtime_error("variable beta_pat_raw missing");
        vals_r__ = context__.vals_r("beta_pat_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_pat_raw", "n_pat", n_pat);
        context__.validate_dims("initialization", "beta_pat_raw", "vector_d", context__.to_vec(n_pat));
        vector_d beta_pat_raw(static_cast<Eigen::VectorXd::Index>(n_pat));
        for (int j1__ = 0U; j1__ < n_pat; ++j1__)
            beta_pat_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pat_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pat_raw: ") + e.what());
        }

        if (!(context__.contains_r("beta_group")))
            throw std::runtime_error("variable beta_group missing");
        vals_r__ = context__.vals_r("beta_group");
        pos__ = 0U;
        validate_non_negative_index("beta_group", "n_group", n_group);
        context__.validate_dims("initialization", "beta_group", "vector_d", context__.to_vec(n_group));
        vector_d beta_group(static_cast<Eigen::VectorXd::Index>(n_group));
        for (int j1__ = 0U; j1__ < n_group; ++j1__)
            beta_group(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_group);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_group: ") + e.what());
        }

        if (!(context__.contains_r("sigma_beta_pat")))
            throw std::runtime_error("variable sigma_beta_pat missing");
        vals_r__ = context__.vals_r("sigma_beta_pat");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_beta_pat", "double", context__.to_vec());
        double sigma_beta_pat(0);
        sigma_beta_pat = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_beta_pat);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_beta_pat: ") + e.what());
        }

        if (!(context__.contains_r("mu_beta")))
            throw std::runtime_error("variable mu_beta missing");
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_beta", "double", context__.to_vec());
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(1,mu_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  m_pat_raw;
            (void) m_pat_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                m_pat_raw = in__.vector_constrain(n_pat,lp__);
            else
                m_pat_raw = in__.vector_constrain(n_pat);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  m_group;
            (void) m_group;  // dummy to suppress unused var warning
            if (jacobian__)
                m_group = in__.vector_constrain(n_group,lp__);
            else
                m_group = in__.vector_constrain(n_group);

            T__ sigma_m_pat;
            (void) sigma_m_pat;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_m_pat = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_m_pat = in__.scalar_lb_constrain(0);

            T__ mu_m;
            (void) mu_m;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_m = in__.scalar_lb_constrain(0,lp__);
            else
                mu_m = in__.scalar_lb_constrain(0);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  k_pat_raw;
            (void) k_pat_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                k_pat_raw = in__.vector_constrain(n_pat,lp__);
            else
                k_pat_raw = in__.vector_constrain(n_pat);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  k_group;
            (void) k_group;  // dummy to suppress unused var warning
            if (jacobian__)
                k_group = in__.vector_constrain(n_group,lp__);
            else
                k_group = in__.vector_constrain(n_group);

            T__ sigma_k_pat;
            (void) sigma_k_pat;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_k_pat = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_k_pat = in__.scalar_lb_constrain(0);

            T__ mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.scalar_lb_constrain(0,lp__);
            else
                mu_k = in__.scalar_lb_constrain(0);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pat_raw;
            (void) beta_pat_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pat_raw = in__.vector_constrain(n_pat,lp__);
            else
                beta_pat_raw = in__.vector_constrain(n_pat);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_group;
            (void) beta_group;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_group = in__.vector_constrain(n_group,lp__);
            else
                beta_group = in__.vector_constrain(n_group);

            T__ sigma_beta_pat;
            (void) sigma_beta_pat;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_beta_pat = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_beta_pat = in__.scalar_lb_constrain(0);

            T__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_beta = in__.scalar_lb_constrain(1,lp__);
            else
                mu_beta = in__.scalar_lb_constrain(1);

            T__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0,lp__);
            else
                sigma = in__.scalar_lb_constrain(0);


            // transformed parameters
            current_statement_begin__ = 36;
            validate_non_negative_index("pdr1", "n", n);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pdr1(static_cast<Eigen::VectorXd::Index>(n));
            (void) pdr1;  // dummy to suppress unused var warning

            stan::math::initialize(pdr1, DUMMY_VAR__);
            stan::math::fill(pdr1,DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("m_pat", "n_pat", n_pat);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  m_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) m_pat;  // dummy to suppress unused var warning

            stan::math::initialize(m_pat, DUMMY_VAR__);
            stan::math::fill(m_pat,DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("k_pat", "n_pat", n_pat);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  k_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) k_pat;  // dummy to suppress unused var warning

            stan::math::initialize(k_pat, DUMMY_VAR__);
            stan::math::fill(k_pat,DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("beta_pat", "n_pat", n_pat);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) beta_pat;  // dummy to suppress unused var warning

            stan::math::initialize(beta_pat, DUMMY_VAR__);
            stan::math::fill(beta_pat,DUMMY_VAR__);
            current_statement_begin__ = 40;
            T__ mn;
            (void) mn;  // dummy to suppress unused var warning

            stan::math::initialize(mn, DUMMY_VAR__);
            stan::math::fill(mn,DUMMY_VAR__);
            current_statement_begin__ = 41;
            T__ kn;
            (void) kn;  // dummy to suppress unused var warning

            stan::math::initialize(kn, DUMMY_VAR__);
            stan::math::fill(kn,DUMMY_VAR__);
            current_statement_begin__ = 42;
            T__ betan;
            (void) betan;  // dummy to suppress unused var warning

            stan::math::initialize(betan, DUMMY_VAR__);
            stan::math::fill(betan,DUMMY_VAR__);


            current_statement_begin__ = 43;
            stan::math::assign(m_pat, multiply(sigma_m_pat,m_pat_raw));
            current_statement_begin__ = 44;
            stan::math::assign(k_pat, multiply(sigma_k_pat,k_pat_raw));
            current_statement_begin__ = 45;
            stan::math::assign(beta_pat, multiply(sigma_beta_pat,beta_pat_raw));
            current_statement_begin__ = 46;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 47;
                int pat(0);
                (void) pat;  // dummy to suppress unused var warning

                stan::math::fill(pat, std::numeric_limits<int>::min());
                current_statement_begin__ = 48;
                int group(0);
                (void) group;  // dummy to suppress unused var warning

                stan::math::fill(group, std::numeric_limits<int>::min());
                current_statement_begin__ = 49;
                T__ exp_ktn;
                (void) exp_ktn;  // dummy to suppress unused var warning

                stan::math::initialize(exp_ktn, DUMMY_VAR__);
                stan::math::fill(exp_ktn,DUMMY_VAR__);


                current_statement_begin__ = 50;
                stan::math::assign(pat, get_base1(pat_i,i,"pat_i",1));
                current_statement_begin__ = 51;
                stan::math::assign(group, get_base1(group_i,i,"group_i",1));
                current_statement_begin__ = 52;
                stan::math::assign(mn, ((mu_m + get_base1(m_pat,pat,"m_pat",1)) + get_base1(m_group,group,"m_group",1)));
                current_statement_begin__ = 53;
                stan::math::assign(kn, ((mu_k + get_base1(k_pat,pat,"k_pat",1)) + get_base1(k_group,group,"k_group",1)));
                current_statement_begin__ = 54;
                stan::math::assign(betan, ((mu_beta + get_base1(beta_pat,pat,"beta_pat",1)) + get_base1(beta_group,group,"beta_group",1)));
                current_statement_begin__ = 55;
                stan::math::assign(exp_ktn, exp((-(kn) * get_base1(minute,i,"minute",1))));
                current_statement_begin__ = 56;
                stan::math::assign(get_base1_lhs(pdr1,i,"pdr1",1), (((((dose * mn) * kn) * betan) * exp_ktn) * pow((1 - exp_ktn),(betan - 1))));
                }
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < n; ++i0__) {
                if (stan::math::is_uninitialized(pdr1(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: pdr1" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < n_pat; ++i0__) {
                if (stan::math::is_uninitialized(m_pat(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: m_pat" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < n_pat; ++i0__) {
                if (stan::math::is_uninitialized(k_pat(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k_pat" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < n_pat; ++i0__) {
                if (stan::math::is_uninitialized(beta_pat(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_pat" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(mn)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mn";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(kn)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: kn";
                throw std::runtime_error(msg__.str());
            }
            if (stan::math::is_uninitialized(betan)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: betan";
                throw std::runtime_error(msg__.str());
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 36;
            current_statement_begin__ = 37;
            current_statement_begin__ = 38;
            current_statement_begin__ = 39;
            current_statement_begin__ = 40;
            check_greater_or_equal(function__,"mn",mn,0);
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"kn",kn,0);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"betan",betan,1);

            // model body

            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(m_pat_raw, 0, 1));
            current_statement_begin__ = 62;
            lp_accum__.add(cauchy_log<propto__>(sigma_m_pat, 0, 5));
            current_statement_begin__ = 63;
            lp_accum__.add(normal_log<propto__>(m_group, 0, 10));
            current_statement_begin__ = 64;
            lp_accum__.add(normal_log<propto__>(mu_m, 40, 30));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(k_pat_raw, 0, 1));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(sigma_k_pat, 0, 0.01));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(k_group, 0, 0.0050000000000000001));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(mu_k, 0.0070000000000000001, 0.002));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(beta_pat_raw, 0, 1));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(sigma_beta_pat, 0, 1));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log<propto__>(beta_group, 0, 0.5));
            current_statement_begin__ = 74;
            lp_accum__.add(normal_log<propto__>(mu_beta, 2, 0.40000000000000002));
            current_statement_begin__ = 76;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            current_statement_begin__ = 77;
            if (as_bool(logical_lt(student_t_df,10))) {

                current_statement_begin__ = 78;
                lp_accum__.add(student_t_log<propto__>(pdr, student_t_df, pdr1, sigma));
            } else {

                current_statement_begin__ = 80;
                lp_accum__.add(normal_log<propto__>(pdr, pdr1, sigma));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("m_pat_raw");
        names__.push_back("m_group");
        names__.push_back("sigma_m_pat");
        names__.push_back("mu_m");
        names__.push_back("k_pat_raw");
        names__.push_back("k_group");
        names__.push_back("sigma_k_pat");
        names__.push_back("mu_k");
        names__.push_back("beta_pat_raw");
        names__.push_back("beta_group");
        names__.push_back("sigma_beta_pat");
        names__.push_back("mu_beta");
        names__.push_back("sigma");
        names__.push_back("pdr1");
        names__.push_back("m_pat");
        names__.push_back("k_pat");
        names__.push_back("beta_pat");
        names__.push_back("mn");
        names__.push_back("kn");
        names__.push_back("betan");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_group);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_group);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_group);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pat);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_breath_test_group_1_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d m_pat_raw = in__.vector_constrain(n_pat);
        vector_d m_group = in__.vector_constrain(n_group);
        double sigma_m_pat = in__.scalar_lb_constrain(0);
        double mu_m = in__.scalar_lb_constrain(0);
        vector_d k_pat_raw = in__.vector_constrain(n_pat);
        vector_d k_group = in__.vector_constrain(n_group);
        double sigma_k_pat = in__.scalar_lb_constrain(0);
        double mu_k = in__.scalar_lb_constrain(0);
        vector_d beta_pat_raw = in__.vector_constrain(n_pat);
        vector_d beta_group = in__.vector_constrain(n_group);
        double sigma_beta_pat = in__.scalar_lb_constrain(0);
        double mu_beta = in__.scalar_lb_constrain(1);
        double sigma = in__.scalar_lb_constrain(0);
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(m_pat_raw[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_group; ++k_0__) {
            vars__.push_back(m_group[k_0__]);
            }
        vars__.push_back(sigma_m_pat);
        vars__.push_back(mu_m);
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(k_pat_raw[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_group; ++k_0__) {
            vars__.push_back(k_group[k_0__]);
            }
        vars__.push_back(sigma_k_pat);
        vars__.push_back(mu_k);
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(beta_pat_raw[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_group; ++k_0__) {
            vars__.push_back(beta_group[k_0__]);
            }
        vars__.push_back(sigma_beta_pat);
        vars__.push_back(mu_beta);
        vars__.push_back(sigma);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 36;
            validate_non_negative_index("pdr1", "n", n);
            vector_d pdr1(static_cast<Eigen::VectorXd::Index>(n));
            (void) pdr1;  // dummy to suppress unused var warning

            stan::math::initialize(pdr1, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pdr1,DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("m_pat", "n_pat", n_pat);
            vector_d m_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) m_pat;  // dummy to suppress unused var warning

            stan::math::initialize(m_pat, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(m_pat,DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("k_pat", "n_pat", n_pat);
            vector_d k_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) k_pat;  // dummy to suppress unused var warning

            stan::math::initialize(k_pat, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(k_pat,DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("beta_pat", "n_pat", n_pat);
            vector_d beta_pat(static_cast<Eigen::VectorXd::Index>(n_pat));
            (void) beta_pat;  // dummy to suppress unused var warning

            stan::math::initialize(beta_pat, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(beta_pat,DUMMY_VAR__);
            current_statement_begin__ = 40;
            double mn(0.0);
            (void) mn;  // dummy to suppress unused var warning

            stan::math::initialize(mn, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mn,DUMMY_VAR__);
            current_statement_begin__ = 41;
            double kn(0.0);
            (void) kn;  // dummy to suppress unused var warning

            stan::math::initialize(kn, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(kn,DUMMY_VAR__);
            current_statement_begin__ = 42;
            double betan(0.0);
            (void) betan;  // dummy to suppress unused var warning

            stan::math::initialize(betan, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(betan,DUMMY_VAR__);


            current_statement_begin__ = 43;
            stan::math::assign(m_pat, multiply(sigma_m_pat,m_pat_raw));
            current_statement_begin__ = 44;
            stan::math::assign(k_pat, multiply(sigma_k_pat,k_pat_raw));
            current_statement_begin__ = 45;
            stan::math::assign(beta_pat, multiply(sigma_beta_pat,beta_pat_raw));
            current_statement_begin__ = 46;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 47;
                int pat(0);
                (void) pat;  // dummy to suppress unused var warning

                stan::math::fill(pat, std::numeric_limits<int>::min());
                current_statement_begin__ = 48;
                int group(0);
                (void) group;  // dummy to suppress unused var warning

                stan::math::fill(group, std::numeric_limits<int>::min());
                current_statement_begin__ = 49;
                double exp_ktn(0.0);
                (void) exp_ktn;  // dummy to suppress unused var warning

                stan::math::initialize(exp_ktn, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(exp_ktn,DUMMY_VAR__);


                current_statement_begin__ = 50;
                stan::math::assign(pat, get_base1(pat_i,i,"pat_i",1));
                current_statement_begin__ = 51;
                stan::math::assign(group, get_base1(group_i,i,"group_i",1));
                current_statement_begin__ = 52;
                stan::math::assign(mn, ((mu_m + get_base1(m_pat,pat,"m_pat",1)) + get_base1(m_group,group,"m_group",1)));
                current_statement_begin__ = 53;
                stan::math::assign(kn, ((mu_k + get_base1(k_pat,pat,"k_pat",1)) + get_base1(k_group,group,"k_group",1)));
                current_statement_begin__ = 54;
                stan::math::assign(betan, ((mu_beta + get_base1(beta_pat,pat,"beta_pat",1)) + get_base1(beta_group,group,"beta_group",1)));
                current_statement_begin__ = 55;
                stan::math::assign(exp_ktn, exp((-(kn) * get_base1(minute,i,"minute",1))));
                current_statement_begin__ = 56;
                stan::math::assign(get_base1_lhs(pdr1,i,"pdr1",1), (((((dose * mn) * kn) * betan) * exp_ktn) * pow((1 - exp_ktn),(betan - 1))));
                }
            }

            // validate transformed parameters
            current_statement_begin__ = 36;
            current_statement_begin__ = 37;
            current_statement_begin__ = 38;
            current_statement_begin__ = 39;
            current_statement_begin__ = 40;
            check_greater_or_equal(function__,"mn",mn,0);
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"kn",kn,0);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"betan",betan,1);

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pdr1[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(m_pat[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(k_pat[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_pat; ++k_0__) {
            vars__.push_back(beta_pat[k_0__]);
            }
        vars__.push_back(mn);
        vars__.push_back(kn);
        vars__.push_back(betan);

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_breath_test_group_1";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pdr1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mn";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "kn";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "betan";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pat_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_group; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_group" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta_pat";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pdr1" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_pat; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mn";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "kn";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "betan";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

}




#endif
