% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_breathtestfit.R
\name{coef.breathtestfit}
\alias{coef.breathtestfit}
\title{S3 coef for breathtestfit}
\usage{
\method{coef}{breathtestfit}(object, ...)
}
\arguments{
\item{object}{of class breathtestfit, as returned by \code{\link{nls_fit}} or 
\code{\link{nlme_fit}}}

\item{...}{other parameters passed to methods}
}
\description{
Extracts the estimates such as t50, tlag, from fitted 13C beta 
exponential models. The result is the same as \code{fit$coef}, but without
column \code{stat}, which always is \code{"estimate"} for \code{\link{nls_fit}}
and \code{\link{nlme_fit}}.
}
\examples{
# Generate simulated data
data = cleanup_data(simulate_breathtest_data()$data)
# Fit with the population method
fit = nlme_fit(data)
# All coefficients in the long form
coef(fit)
# Access coefficients directly
fit$coef
# Can also be used with stan fit (slow!)
\dontrun{
if (require("breathteststan")) {
  fit = breathteststan::stan_fit(data)
  coef(fit)
  # We get quantiles here, not only estimates
  unique(fit$coef$stat)
}
}
}
