#' @title Zurich sample set of 13C breath test data
#'
#' @description 13C time series PDR data from normals and random patients
#' from the division of \href{http://www.gastroenterologie.usz.ch/Seiten/default.aspx}{Gastroenterology and Hepatology,
#' University Hospital Zurich}.
#' Most breath samples from normals were collected with bags and analyzed by
#' \href{http://kibion.com/content/uploads/2013/07/113-01_IRIS_Consumables_DE.pdf}{IRIS/Wagner}
#' infrared spectroscopy. Patient samples were recorded with the continuous
#' monitoring system
#' \href{http://www.exalenz.com/mainmenu/breathid-hp/urea-breath-test}{BreathID}.
#'
#' \describe{
#'   \item{patient_id}{Patient identifier, starting with \code{norm} for normals
#'   (healthy volunteers) and  \code{pat} for patients. Note that for normals
#'   there are two records for each subject, so only the combination of patient_id 
#'   and group is a unique identifier of the time series record.}
#'   \item{group}{\code{liquid_normal} for normals and liquid meal,
#'   \code{solid_normal} normals and solid meal, and \code{patient} for patients;
#'   patients are an unselected cross-section from the University Hospital of Zurich.}
#'   \item{minute}{Time in minutes}
#'   \item{pdr}{PDR as computed by breathtest device or from dob via function dob_to_pdr}
#' }
#' @docType data
#' @keywords datasets
#' @name usz_13c
#' @usage data(usz_13c)
#' @examples 
#' data(usz_13c)
#' \dontrun{
#' str(usz_13c)
#' # Plot all records; this needs some time
#' pdf("usz_13c.pdf", height= 30)
#' # null_fit makes data plotable without fitting a model
#' plot(null_fit(usz_13c))
#' dev.off()
#' }
#' # Plot a subset
#' suppressPackageStartupMessages(library(dplyr))
#' usz_part =  usz_13c  %>% 
#'   filter(patient_id %in% c("norm_001","norm_002", "pat_001", "pat_002"))
#' plot(null_fit(usz_part))
#' @format A data frame with 15574 rows and 4 variables
#' 
#' 
#' @import assertthat
#' @import ggplot2
#' @import stringr
#' @import dplyr
#' @import readr
#' @importFrom broom augment tidy
#' @importFrom MASS mvrnorm
#' @importFrom graphics plot plot.default
#' @importFrom purrr map_df
#' @importFrom stats rt rnorm na.omit rlnorm coef AIC deviance
#' @importFrom utils capture.output
#' @importFrom signal interp1
#' @importFrom methods is
#' @importFrom tibble rownames_to_column as_tibble
#' @importFrom nlme nlme nlmeControl fixef nlsList
NULL
