% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{alcdfstd}
\alias{alcdfstd}
\title{cdf of a standard asymmetric Laplace distribution}
\usage{
alcdfstd(x, p)
}
\arguments{
\item{x}{scalar value.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns the cumulative probability value at point x for a standard
AL distribution.
}
\description{
This function computes the cdf of a standard AL
distribution i.e. AL\eqn{(0, 1 ,p)}.
}
\details{
Computes the cdf of a standard AL distribution.
\deqn{cdf(x) = F(x) = P(X \le x)} where X is a
random variable that follows AL\eqn{(0, 1 ,p)}.
}
\examples{
set.seed(101)
x <-  -0.5428573
p <- 0.25
output <- alcdfstd(x, p)

# output
#   0.1663873

}
\references{
Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
}
\seealso{
asymmetric Laplace distribution
}
