% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_pattern.R
\name{match_pattern}
\alias{match_pattern}
\title{Pattern Matching}
\usage{
match_pattern(x, pattern, unique_only = FALSE, ...)
}
\arguments{
\item{x}{A vector, typically of class \code{"character"}.}

\item{pattern}{Character string specifying the particular pattern to match.}

\item{unique_only}{Logical indicating whether or not to only return unique
values. Default is \code{FALSE}.}

\item{...}{Additional optional arguments to ba passed onto 
\code{\link{get_pattern}}.}
}
\description{
Extract values from a vector that match a particular pattern.
}
\details{
The pattern specified by the required argument \code{pattern} must be a valid
pattern produced by the \code{get_pattern} function. That is, all digits
should be represented by a \code{"9"}, lowercase/uppercase letters by a 
\code{"a"}/\code{"A"}, etc.
}
\examples{
phone <- c("123-456-7890", "456-7890", "123-4567", "456-7890")
match_pattern(phone, pattern = "999-9999")
match_pattern(phone, pattern = "999-9999", unique_only = TRUE)
}

