% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_save_load.R
\name{box_save}
\alias{box_save}
\alias{box_load}
\alias{box_save_image}
\title{Download/upload an R workspace from/to a Box file}
\usage{
box_save(..., dir_id = box_getwd(), file_name = ".RData", description = NULL)

box_save_image(
  dir_id = box_getwd(),
  file_name = ".RData",
  description = NULL,
  filename
)

box_load(file_id)
}
\arguments{
\item{...}{Objects to be saved, quoted or unquoted; passed to \code{save()}.}

\item{dir_id}{\code{numeric} or \code{character}, folder ID at Box.}

\item{file_name}{\code{character}, if supplied, an alternate filename
for the local version of the Box file.}

\item{description}{\code{character}, description caption for the file.}

\item{filename}{\code{character}, \strong{deprecated}: use \code{file_name} instead.}

\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}
}
\value{
\describe{
\item{\verb{box_save(), box_save_image()}}{Object with S3 class
\code{\link[=boxr_S3_classes]{boxr_file_reference}}.}
\item{\code{box_load()}}{From \code{\link[=load]{load()}}, a character vector of the names of
objects created, invisibly.}
}
}
\description{
Use these functions to save and load workspaces or collections of objects
to or from Box. Similar to \code{\link[=save]{save()}}, \code{\link[=save.image]{save.image()}}, and \code{\link[=load]{load()}}:
these functions operate on files at Box instead of on local files.
}
\details{
\describe{
\item{\code{box_save()}}{Save object(s) using \code{\link[=save]{save()}}, write to Box.}
\item{\code{box_save_image()}}{Save workspace image using \code{\link[=save.image]{save.image()}},
write to Box.}
\item{\code{box_load()}}{Read from Box, load using \code{\link[=load]{load()}}.}
}
}
\seealso{
\code{\link[=save]{save()}}, \code{\link[=save.image]{save.image()}}, \code{\link[=load]{load()}}
}
