% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCoxmix.R
\name{np.boxcoxmix}
\alias{np.boxcoxmix}
\title{Response Transformations for Random Effect and Variance Component Models}
\usage{
np.boxcoxmix(
  formula,
  groups = 1,
  data,
  K = 3,
  tol = 0.5,
  lambda = 1,
  steps = 500,
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  start = "gq",
  ...
)
}
\arguments{
\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{groups}{the random effects. To fit overdispersion models , set \code{groups} = 1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{K}{the number of mass points.}

\item{tol}{a positive scalar (usually, 0< \code{tol} <= 2)}

\item{lambda}{a transformation parameter, setting \code{lambda}=1 means 'no
transformation'.}

\item{steps}{maximum number of iterations for the EM algorithm.}

\item{EMdev.change}{a small scalar, with default 0.0001, used to determine
when to stop EM algorithm.}

\item{plot.opt}{Set \code{plot.opt=1}, to plot the disparity against
iteration number. Use \code{plot.opt=2} for \code{tolfind.boxcox()} and \code{plot.opt=3}
for \code{optim.boxcox()}.}

\item{verbose}{If set to FALSE, no printed output on progress.}

\item{start}{a description of the initial values to be used in the fitted
model, Quantile-based version "quantile" or Gaussian Quadrature "gq" can be
set.}

\item{\dots}{extra arguments will be ignored.}
}
\value{
\item{mass.point}{the fitted mass points.} \item{p}{the masses corresponding to the mixing proportions.} \item{beta}{the
vector of coefficients.} \item{sigma}{the standard deviation of the mixing distribution (the square root of the variance).} \item{se}{the standard error of the estimate.}
\item{w}{a matrix of posterior probabilities that element i comes from cluster k.}
\item{loglik}{the log-likelihood of the fitted regression model.}
\item{complete.loglik}{the complete log-likelihood of the fitted regression model.}
\item{disparity}{the disparity of the fitted regression model.} \item{EMiteration}{provides the number of iterations of the EM algorithm.} 
\item{EMconverged}{TRUE means the EM algorithm converged.} \item{call}{the matched call.} \item{formula}{the formula provided.}
\item{data}{the data argument.} \item{aic}{the Akaike information criterion of the fitted regression model.}
 \item{bic}{the Bayesian information criterion of the fitted regression model.}
\item{fitted}{the fitted values for the individual observations.} \item{fitted.transformed}{the fitted values for
the individual transformed observations.} \item{residuals}{the difference between the observed values and the fitted values.}
\item{residuals.transformed}{the difference between the transformed observed values and the transformed fitted values.}
\item{predicted.re}{a vector of predicted residuals.}

The other outcomes are not relevant to users and they are intended for internal use only.
}
\description{
The function \code{np.boxcoxmix()} fits an overdispersed generalized linear model
and variance component models using nonparametric profile maximum likelihood.
}
\details{
The Box-Cox transformation (Box & Cox, 1964) is applied to the overdispersed
generalized linear models and variance component models with an unspecified
mixing distribution. The NPML estimate of the mixing distribution is known
to be a discrete distribution involving a finite number of mass-points and corresponding
masses (Aitkin et al., 2009). An Expectation-Maximization (EM) algorithm is
used for fitting the finite mixture distribution, one needs to specify the
number of components \code{K} of the finite mixture in advance. To stop the EM-algorithm
when it reached its convergence point, we need to defined the convergence criteria that is 
the absolute change in the successive log-likelihood function values being less than an arbitrary 
parameter such as \code{EMdev.change} = 0.0001 (Einbeck et at., 2014). This algorithm can be 
implemented using the function \code{np.boxcoxmix()}, which is designed to account for 
overdispersed generalized linear models and variance component models using the non-parametric
profile maximum likelihood (NPPML) estimation.


The ability of the EM algorithm to locate the global maximum in fewer iterations
can be affected by the choice of initial values, the function \code{np.boxcoxmix()}
allows us to choose from two different methods to set the initial value of the mass
points. When option "gq" is set, then Gauss-Hermite masses and mass points are used
as starting points in the EM algorithm, while setting start= "quantile" uses the 
Quantile-based version to select the starting points.
}
\examples{
#Pennsylvanian Hospital Stay Data
data(hosp, package = "npmlreg")
test1 <- np.boxcoxmix(duration ~ age + wbc1, data = hosp, K = 2, tol = 1, 
    start = "quantile", lambda = 1)
round(summary(test1)$w, digits = 3)
# [1,] 1.000 0.000

# Refinery yield of gasoline Data
data(Gasoline, package = "nlme")
test2.vc <- np.boxcoxmix(yield ~ endpoint + vapor, groups = Gasoline$Sample, 
      data = Gasoline, K = 3, tol = 1.7, start = "quantile", lambda = 0)
test2.vc$disparity
# [1] 176.9827








}
\references{
Box G. and Cox D. (1964). An analysis of transformations. Journal of
the Royal Statistical Society. Series B (Methodological), pages 211-252.

Aitkin, M. A., Francis, B., Hinde, J., and Darnell, R. (2009). Statistical
modelling in R. Oxford University Press Oxford.

Jochen Einbeck, Ross Darnell and John Hinde (2014). npmlreg:
Nonparametric maximum likelihood estimation for random effect
models. R package version 0.46-1.
}
\seealso{
\code{\link{optim.boxcox}}, \code{\link{tolfind.boxcox}}.
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{boxcox}
\keyword{random}
\keyword{variance}
