% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tolfind.boxcox.R
\name{tolfind.boxcox}
\alias{tolfind.boxcox}
\title{Grid search over tol for NPPML estimation of random effect and variance component models}
\usage{
tolfind.boxcox(formula, groups = 1, data, K = 3, lambda = 1,
  EMdev.change = 1e-04, plot.opt = 2, s = 20, steps = 500,
  find.in.range = c(0, 2), start = "gq", verbose = FALSE,
  noformat = FALSE, ...)
}
\arguments{
\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{groups}{the random effects. To fit overdispersion models , set \code{groups} = 1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{K}{the number of mass points.}

\item{lambda}{a transformation parameter, setting \code{lambda}=1 means 'no
transformation'.}

\item{EMdev.change}{a small scalar, with default 0.0001, used to determine
when to stop EM algorithm.}

\item{plot.opt}{Set \code{plot.opt=2}, to plot the disparity against
iteration number.}

\item{s}{number of points in the grid search of \code{tol}.}

\item{steps}{maximum number of iterations for the EM algorithm.}

\item{find.in.range}{search in a range of \code{tol}, with default (0,2) in
step of 0.1 .}

\item{start}{a description of the initial values to be used in the fitted
model, Quantile-based version "quantile" or Gaussian Quadrature "gq" can be
set.}

\item{verbose}{If set to FALSE, no printed output on progress.}

\item{noformat}{Set \code{noformat = TRUE}, to change the formatting of the plots.}

\item{\dots}{extra arguments will be ignored.}
}
\value{
\item{MinDisparity}{the minimum disparity found.} \item{Mintol}{the
value of \code{tol} corresponding to \code{MinDisparity}.}
\item{AllDisparities }{a vector containing all disparities calculated on the
grid.} \item{Alltol }{list of \code{tol} values used in the grid.}
\item{AllEMconverged }{1 is TRUE, means the EM algorithm converged.}
}
\description{
A grid search over the parameter \code{tol}, to set the initial values of
the EM algorithm.
}
\details{
A grid search over \code{tol} can be performed using \code{tolfind.boxcox()}
function, which works for \code{np.boxcoxmix()} to find the
optimal solution.
}
\examples{
# The Pennsylvanian Hospital Stay Data
data(hosp, package = "npmlreg")
test1 <- tolfind.boxcox(duration ~ age , data = hosp, K = 2, lambda = 0, 
    s = 10, steps = 600, start = "quantile", plot.opt = 0)
# Minimal Disparity: 137.8364 at tol= 1.4  
# Minimal Disparity with EM converged: 137.8364 at tol= 1.4 

# Effect of Phenylbiguanide on Blood Pressure
data(PBG, package = "nlme")
test3 <- tolfind.boxcox(deltaBP ~ dose , groups = PBG$Rabbit, 
    data = PBG, K = 2, lambda = -1, s = 15, steps = 500, start = "quantile", plot.opt = 0)
# Minimal Disparity: 449.5876 at tol= 1.6 
# Minimal Disparity with EM converged: 449.5876 at tol= 1.6









}
\seealso{
\code{\link{np.boxcoxmix}}.
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{boxcox}
\keyword{tolfind}
